package name.remal.building.gradle_plugins.gitlab_tools

import name.remal.building.gradle_plugins.API
import org.gradle.api.tasks.TaskAction

@API
class GitlabCreateTagTask : AbstractGitlabRefTask() {

    var tagName: String? = null
        get() = field ?: "ver-${project.version}"

    @TaskAction
    protected fun createTag() {
        val tagName = this.tagName
        executeApiRequest<Any?>(
            Method.POST,
            "/projects/:id/repository/tags",
            mapOf(
                "id" to PROJECT_ID,
                "ref" to gitRef,
                "tag_name" to tagName
            )
        )

        logger.warn("Tag {} was successfully created", tagName)
    }

}
