package name.remal.building.gradle_plugins.utils;

import org.gradle.api.JavaVersion;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public interface Compatibility {

    JavaVersion DEFAULT_MIN_JAVA_VERSION = JavaVersion.VERSION_1_8;

    static void checkMinJavaVersion() {
        checkMinJavaVersion(DEFAULT_MIN_JAVA_VERSION);
    }

    static void checkMinJavaVersion(@NotNull JavaVersion version) {
        JavaVersion current = JavaVersion.current();
        if (current.compareTo(version) < 0) {
            throw new TooOldJavaVersion(current.toString(), version.toString());
        }
    }

    class TooOldJavaVersion extends RuntimeException {
        public TooOldJavaVersion(String currentVersion, String requiredVersion) {
            super("Too old Java version - " + currentVersion + ", required - " + requiredVersion);
        }
    }

    GradleVersion DEFAULT_MIN_GRADLE_VERSION = GradleVersion.version("3.5");

    static void checkMinGradleVersion() {
        checkMinGradleVersion(DEFAULT_MIN_GRADLE_VERSION);
    }

    static void checkMinGradleVersion(@NotNull GradleVersion version) {
        GradleVersion current = GradleVersion.current();
        if (current.compareTo(version) < 0) {
            throw new TooOldGradleVersion(current.getVersion(), version.getVersion());
        }
    }

    class TooOldGradleVersion extends RuntimeException {
        public TooOldGradleVersion(String currentVersion, String requiredVersion) {
            super("Too old Gradle version - " + currentVersion + ", required - " + requiredVersion);
        }

    }

}
