package name.remal.building.gradle_plugins.utils

import name.remal.building.gradle_plugins.dsl.DEFAULT_IO_TIMEOUT
import name.remal.building.gradle_plugins.dsl.contentCharset
import name.remal.building.gradle_plugins.dsl.use
import java.net.HttpURLConnection
import java.net.URL

internal fun URL.getHttpBody(): String {
    val connection = openConnection()
    connection as HttpURLConnection
    connection.connectTimeout = DEFAULT_IO_TIMEOUT.toMillis().toInt()
    connection.readTimeout = 10 * DEFAULT_IO_TIMEOUT.toMillis().toInt()
    connection.useCaches = false
    connection.instanceFollowRedirects = true
    connection.connect()
    try {
        val responseCode = connection.responseCode
        if (400 <= responseCode) throw IllegalStateException("Error getting HTTP body of $this: status ${connection.responseCode} ${connection.responseMessage}")

        return (connection.errorStream ?: connection.inputStream).reader(connection.contentCharset).use { it.readText() }

    } finally {
        connection.disconnect()
    }
}
