package name.remal.building.gradle_plugins.vcs

import name.remal.building.gradle_plugins.utils.RESOURCES_CLASS_LOADER
import org.gradle.api.Project
import org.slf4j.LoggerFactory
import java.util.*

internal val VCS_SERVICE_FACTORIES: List<VCSServiceFactory> = ServiceLoader.load(VCSServiceFactory::class.java, RESOURCES_CLASS_LOADER).toList().sorted().also {
    if (it.isEmpty()) {
        LoggerFactory.getLogger(VCSServiceFactory::class.java).error("Instances of ${VCSServiceFactory::class.java} are not registered")
    }
}

internal fun Project.getVCSService(): VCSService? {
    var repositoryRootDir = this.rootDir.absoluteFile
    while (true) {
        VCS_SERVICE_FACTORIES
            .firstOrNull { it.isDirMatches(repositoryRootDir) }
            ?.let { return it.createVCSService(repositoryRootDir) }

        val parentDir = repositoryRootDir.parentFile ?: break
        if (repositoryRootDir == parentDir) break
        repositoryRootDir = parentDir
    }

    return null
}

internal inline fun Project.forVCSService(action: (VCSService) -> Unit) {
    this.getVCSService()?.let(action)
}
