/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.reflect.KCallable;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.ModuleByClassLoaderKt;
import kotlin.reflect.jvm.internal.UtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.components.RuntimeSourceElementFactory;
import kotlin.reflect.jvm.internal.impl.load.java.reflect.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.RuntimeModuleData;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.SinceKotlinInfoTable;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001af\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0010\"\b\b\u0001\u0010\u000e*\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u0002H\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001d\u0010\u0019\u001a\u0019\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u001a\u00a2\u0006\u0002\b\u001cH\u0000\u00a2\u0006\u0002\u0010\u001d\u001a&\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0000\u001a\"\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0080\b\u00a2\u0006\u0002\u0010'\u001a\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)*\u0004\u0018\u00010*H\u0000\u001a\u0010\u0010+\u001a\u0004\u0018\u00010,*\u0004\u0018\u00010*H\u0000\u001a\u0014\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.*\u0004\u0018\u00010*H\u0000\u001a\u0012\u0010/\u001a\b\u0012\u0004\u0012\u00020100*\u000202H\u0000\u001a\u0012\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u000204H\u0000\u001a\u000e\u00105\u001a\u0004\u0018\u000106*\u000207H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00068"}, d2={"JVM_STATIC", "Lkotlin/reflect/jvm/internal/impl/name/FqName;", "getJVM_STATIC", "()Lorg/jetbrains/kotlin/name/FqName;", "isPublicInBytecode", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableMemberDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z", "packageModuleName", "", "Lkotlin/reflect/jvm/internal/impl/load/kotlin/reflect/ReflectKotlinClass;", "getPackageModuleName", "(Lorg/jetbrains/kotlin/load/kotlin/reflect/ReflectKotlinClass;)Ljava/lang/String;", "deserializeToDescriptor", "D", "M", "Lkotlin/reflect/jvm/internal/impl/protobuf/MessageLite;", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "moduleAnchor", "Ljava/lang/Class;", "proto", "nameResolver", "Lkotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver;", "typeTable", "Lkotlin/reflect/jvm/internal/impl/serialization/deserialization/TypeTable;", "createDescriptor", "Lkotlin/Function2;", "Lkotlin/reflect/jvm/internal/impl/serialization/deserialization/MemberDeserializer;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/protobuf/MessageLite;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "loadClass", "classLoader", "Ljava/lang/ClassLoader;", "packageName", "className", "reflectionCall", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asKCallableImpl", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "", "asKFunctionImpl", "Lkotlin/reflect/jvm/internal/KFunctionImpl;", "asKPropertyImpl", "Lkotlin/reflect/jvm/internal/KPropertyImpl;", "computeAnnotations", "", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/annotations/Annotated;", "toJavaClass", "Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "toKVisibility", "Lkotlin/reflect/KVisibility;", "Lkotlin/reflect/jvm/internal/impl/descriptors/Visibility;", "kotlin-reflection"})
public final class UtilKt {
    @NotNull
    private static final FqName JVM_STATIC = new FqName("kotlin.jvm.JvmStatic");

    @NotNull
    public static final FqName getJVM_STATIC() {
        return JVM_STATIC;
    }

    @Nullable
    public static final Class<?> toJavaClass(@NotNull ClassDescriptor $receiver) {
        AnnotatedElement annotatedElement;
        SourceElement source;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SourceElement sourceElement = source = $receiver.getSource();
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            if (kotlinJvmBinaryClass == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClass");
            }
            annotatedElement = ((ReflectKotlinClass)kotlinJvmBinaryClass).getKlass();
        } else if (sourceElement instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
            ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)source).getJavaElement();
            if (reflectJavaElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.reflect.ReflectJavaClass");
            }
            annotatedElement = ((ReflectJavaClass)reflectJavaElement).getElement();
        } else {
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($receiver);
            Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(this)");
            ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
            if (classId == null) {
                classId = DescriptorUtilsKt.getClassId($receiver);
            }
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            String packageName = classId2.getPackageFqName().asString();
            String className = classId2.getRelativeClassName().asString();
            ClassLoader classLoader = ReflectClassUtilKt.getSafeClassLoader($receiver.getClass());
            String string = packageName;
            Intrinsics.checkExpressionValueIsNotNull(string, "packageName");
            String string2 = className;
            Intrinsics.checkExpressionValueIsNotNull(string2, "className");
            annotatedElement = UtilKt.loadClass(classLoader, string, string2);
        }
        return annotatedElement;
    }

    @Nullable
    public static final Class<?> loadClass(@NotNull ClassLoader classLoader, @NotNull String packageName, @NotNull String className) {
        Intrinsics.checkParameterIsNotNull(classLoader, "classLoader");
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Intrinsics.checkParameterIsNotNull(className, "className");
        if (Intrinsics.areEqual(packageName, "kotlin")) {
            switch (className) {
                case "Array": {
                    return Object[].class;
                }
                case "BooleanArray": {
                    return boolean[].class;
                }
                case "ByteArray": {
                    return byte[].class;
                }
                case "CharArray": {
                    return char[].class;
                }
                case "DoubleArray": {
                    return double[].class;
                }
                case "FloatArray": {
                    return float[].class;
                }
                case "IntArray": {
                    return int[].class;
                }
                case "LongArray": {
                    return long[].class;
                }
                case "ShortArray": {
                    return short[].class;
                }
            }
        }
        return ReflectJavaClassFinderKt.tryLoadClass(classLoader, "" + packageName + '.' + StringsKt.replace$default(className, '.', '$', false, 4, null));
    }

    @Nullable
    public static final KVisibility toKVisibility(@NotNull Visibility $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Visibility visibility = $receiver;
        return Intrinsics.areEqual(visibility, Visibilities.PUBLIC) ? KVisibility.PUBLIC : (Intrinsics.areEqual(visibility, Visibilities.PROTECTED) ? KVisibility.PROTECTED : (Intrinsics.areEqual(visibility, Visibilities.INTERNAL) ? KVisibility.INTERNAL : (Intrinsics.areEqual(visibility, Visibilities.PRIVATE) || Intrinsics.areEqual(visibility, Visibilities.PRIVATE_TO_THIS) ? KVisibility.PRIVATE : null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Annotation> computeAnnotations(@NotNull Annotated $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getAnnotations();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Annotation annotation;
            Annotation annotation2;
            Object element$iv$iv = element$iv$iv$iv;
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            SourceElement source = it.getSource();
            SourceElement sourceElement = source;
            if (sourceElement instanceof ReflectAnnotationSource) {
                annotation2 = ((ReflectAnnotationSource)source).getAnnotation();
            } else if (sourceElement instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
                ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)source).getJavaElement();
                if (!(reflectJavaElement instanceof ReflectJavaAnnotation)) {
                    reflectJavaElement = null;
                }
                ReflectJavaAnnotation reflectJavaAnnotation = (ReflectJavaAnnotation)reflectJavaElement;
                annotation2 = reflectJavaAnnotation != null ? reflectJavaAnnotation.getAnnotation() : null;
            } else {
                annotation2 = null;
            }
            if (annotation2 == null) continue;
            Annotation it$iv$iv = annotation = annotation2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final KFunctionImpl asKFunctionImpl(@Nullable Object $receiver) {
        KFunctionImpl kFunctionImpl;
        Object object = $receiver;
        if (!(object instanceof KFunctionImpl)) {
            object = null;
        }
        if ((kFunctionImpl = (KFunctionImpl)object) == null) {
            Object object2 = $receiver;
            if (!(object2 instanceof FunctionReference)) {
                object2 = null;
            }
            FunctionReference functionReference = (FunctionReference)object2;
            KCallable kCallable = functionReference != null ? functionReference.compute() : null;
            if (!(kCallable instanceof KFunctionImpl)) {
                kCallable = null;
            }
            kFunctionImpl = (KFunctionImpl)kCallable;
        }
        return kFunctionImpl;
    }

    @Nullable
    public static final KPropertyImpl<?> asKPropertyImpl(@Nullable Object $receiver) {
        KPropertyImpl kPropertyImpl;
        Object object = $receiver;
        if (!(object instanceof KPropertyImpl)) {
            object = null;
        }
        if ((kPropertyImpl = (KPropertyImpl)object) == null) {
            Object object2 = $receiver;
            if (!(object2 instanceof PropertyReference)) {
                object2 = null;
            }
            PropertyReference propertyReference = (PropertyReference)object2;
            KCallable kCallable = propertyReference != null ? propertyReference.compute() : null;
            if (!(kCallable instanceof KPropertyImpl)) {
                kCallable = null;
            }
            kPropertyImpl = (KPropertyImpl)kCallable;
        }
        return kPropertyImpl;
    }

    @Nullable
    public static final KCallableImpl<?> asKCallableImpl(@Nullable Object $receiver) {
        KCallableImpl kCallableImpl;
        KCallableImpl kCallableImpl2;
        Object object = $receiver;
        if (!(object instanceof KCallableImpl)) {
            object = null;
        }
        if ((kCallableImpl2 = (KCallableImpl)object) == null) {
            kCallableImpl2 = kCallableImpl = (KCallableImpl)UtilKt.asKFunctionImpl($receiver);
        }
        if (kCallableImpl2 == null) {
            kCallableImpl = UtilKt.asKPropertyImpl($receiver);
        }
        return kCallableImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getPackageModuleName(@NotNull ReflectKotlinClass $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinClassHeader header = $receiver.getClassHeader();
        if (!header.getMetadataVersion().isCompatible()) {
            return null;
        }
        switch (UtilKt$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: 
            case 2: {
                String[] stringArray = header.getData();
                if (stringArray == null) {
                    Intrinsics.throwNpe();
                }
                String[] stringArray2 = header.getStrings();
                if (stringArray2 == null) {
                    Intrinsics.throwNpe();
                }
                PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(stringArray, stringArray2);
                NameResolver nameResolver = packageData.component1();
                ProtoBuf.Package proto = packageData.component2();
                if (proto.hasExtension(JvmProtoBuf.packageModuleName)) {
                    void nameResolver2;
                    Integer n = proto.getExtension(JvmProtoBuf.packageModuleName);
                    Intrinsics.checkExpressionValueIsNotNull(n, "proto.getExtension(JvmProtoBuf.packageModuleName)");
                    string = nameResolver2.getString(((Number)n).intValue());
                    break;
                }
                string = "main";
                break;
            }
            case 3: {
                String string2 = CollectionsKt.firstOrNull(header.getMultifilePartNames());
                if (string2 == null) {
                    return null;
                }
                String partName = string2;
                Class<?> clazz = $receiver.getKlass().getClassLoader().loadClass(StringsKt.replace$default(partName, '/', '.', false, 4, null));
                Intrinsics.checkExpressionValueIsNotNull(clazz, "klass.classLoader.loadCl\u2026rtName.replace('/', '.'))");
                ReflectKotlinClass reflectKotlinClass = ReflectKotlinClass.Factory.create(clazz);
                if (reflectKotlinClass != null) {
                    string = UtilKt.getPackageModuleName(reflectKotlinClass);
                    break;
                }
                string = null;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static final boolean isPublicInBytecode(@NotNull CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Visibility visibility = $receiver.getVisibility();
        return (Intrinsics.areEqual(visibility, Visibilities.PUBLIC) || Intrinsics.areEqual(visibility, Visibilities.INTERNAL)) && !AnnotationUtilKt.isEffectivelyInlineOnly($receiver);
    }

    @Nullable
    public static final <M extends MessageLite, D extends CallableDescriptor> D deserializeToDescriptor(@NotNull Class<?> moduleAnchor, @NotNull M proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull Function2<? super MemberDeserializer, ? super M, ? extends D> createDescriptor) {
        List<ProtoBuf.TypeParameter> list2;
        Intrinsics.checkParameterIsNotNull(moduleAnchor, "moduleAnchor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        Intrinsics.checkParameterIsNotNull(createDescriptor, "createDescriptor");
        RuntimeModuleData moduleData2 = ModuleByClassLoaderKt.getOrCreateModule(moduleAnchor);
        M m = proto;
        if (m instanceof ProtoBuf.Function) {
            list2 = ((ProtoBuf.Function)proto).getTypeParameterList();
        } else if (m instanceof ProtoBuf.Property) {
            list2 = ((ProtoBuf.Property)proto).getTypeParameterList();
        } else {
            String string = "Unsupported message: " + proto;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        List<ProtoBuf.TypeParameter> typeParameters2 = list2;
        DeserializationComponents deserializationComponents = moduleData2.getDeserialization();
        DeclarationDescriptor declarationDescriptor = moduleData2.getModule();
        SinceKotlinInfoTable sinceKotlinInfoTable = SinceKotlinInfoTable.Companion.getEMPTY();
        List<ProtoBuf.TypeParameter> list3 = typeParameters2;
        Intrinsics.checkExpressionValueIsNotNull(list3, "typeParameters");
        DeserializationContext context = new DeserializationContext(deserializationComponents, nameResolver, declarationDescriptor, typeTable, sinceKotlinInfoTable, null, null, list3);
        return (D)((CallableDescriptor)createDescriptor.invoke(new MemberDeserializer(context), proto));
    }
}

