/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleType> supertypesDeque;
    private Set<SimpleType> supertypesSet;
    private final boolean errorTypeEqualsToAnything;
    private final boolean allowedTypeVariable;

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
        Intrinsics.checkParameterIsNotNull(subType, "subType");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return null;
    }

    public boolean areEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Intrinsics.areEqual(a, b);
    }

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull SimpleType subType, @NotNull NewCapturedType superType) {
        Intrinsics.checkParameterIsNotNull(subType, "subType");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @NotNull
    public SeveralSupertypesWithSameConstructorPolicy getSameConstructorPolicy() {
        return SeveralSupertypesWithSameConstructorPolicy.INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
    }

    private final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque();
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    private final void clear() {
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        arrayDeque.clear();
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean anySupertype$kotlin_reflection(@NotNull SimpleType start, @NotNull Function1<? super SimpleType, Boolean> predicate, @NotNull Function1<? super SimpleType, ? extends SupertypesPolicy> supertypesPolicy) {
        Object object;
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Intrinsics.checkParameterIsNotNull(supertypesPolicy, "supertypesPolicy");
        this.initialize();
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        ArrayDeque<SimpleType> deque = arrayDeque;
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        Set<SimpleType> visitedSupertypes = set;
        deque.push(start);
        while (!(object = (Collection)deque).isEmpty()) {
            SupertypesPolicy policy;
            SimpleType current;
            if (visitedSupertypes.size() > 1000) {
                object = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes, null, null, null, 0, null, null, 63, null);
                throw (Throwable)new IllegalStateException(object.toString());
            }
            SimpleType simpleType2 = current = deque.pop();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "current");
            if (!visitedSupertypes.add(simpleType2)) continue;
            if (predicate.invoke(current).booleanValue()) {
                this.clear();
                return true;
            }
            SupertypesPolicy supertypesPolicy2 = supertypesPolicy.invoke(current);
            SupertypesPolicy it = supertypesPolicy2;
            if ((Intrinsics.areEqual(it, SupertypesPolicy.None.INSTANCE) ^ true ? supertypesPolicy2 : null) == null) {
                continue;
            }
            policy = policy;
            Iterator<KotlinType> iterator2 = current.getConstructor().getSupertypes().iterator();
            while (iterator2.hasNext()) {
                KotlinType supertype;
                KotlinType kotlinType = supertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "supertype");
                deque.add(policy.transformType(kotlinType));
            }
        }
        this.clear();
        return false;
    }

    public final boolean isAllowedTypeVariable(@NotNull UnwrappedType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return this.allowedTypeVariable && $receiver.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public final boolean getErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    public TypeCheckerContext(boolean errorTypeEqualsToAnything, boolean allowedTypeVariable) {
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
        this.allowedTypeVariable = allowedTypeVariable;
    }

    public /* synthetic */ TypeCheckerContext(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    public static final /* synthetic */ int access$getArgumentsDepth$p(TypeCheckerContext $this) {
        return $this.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth$p(TypeCheckerContext $this, int n) {
        $this.argumentsDepth = n;
    }

    public static abstract class SupertypesPolicy {
        @NotNull
        public abstract SimpleType transformType(@NotNull KotlinType var1);

        private SupertypesPolicy() {
        }

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE;

            @NotNull
            public Void transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                throw (Throwable)new UnsupportedOperationException("Should not be called");
            }

            private None() {
                super(null);
                INSTANCE = this;
            }

            static {
                new None();
            }
        }

        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return FlexibleTypesKt.upperIfFlexible(type2);
            }

            private UpperIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new UpperIfFlexible();
            }
        }

        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return FlexibleTypesKt.lowerIfFlexible(type2);
            }

            private LowerIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new LowerIfFlexible();
            }
        }

        public static final class LowerIfFlexibleWithCustomSubstitutor
        extends SupertypesPolicy {
            @NotNull
            private final TypeSubstitutor substitutor;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return TypeSubstitutionKt.asSimpleType(this.substitutor.safeSubstitute(FlexibleTypesKt.lowerIfFlexible(type2), Variance.INVARIANT));
            }

            public LowerIfFlexibleWithCustomSubstitutor(@NotNull TypeSubstitutor substitutor) {
                Intrinsics.checkParameterIsNotNull(substitutor, "substitutor");
                super(null);
                this.substitutor = substitutor;
            }
        }
    }

    public static final class SeveralSupertypesWithSameConstructorPolicy
    extends Enum<SeveralSupertypesWithSameConstructorPolicy> {
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy TAKE_FIRST_FOR_SUBTYPING;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy FORCE_NOT_SUBTYPE;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy CHECK_ANY_OF_THEM;
        public static final /* enum */ SeveralSupertypesWithSameConstructorPolicy INTERSECT_ARGUMENTS_AND_CHECK_AGAIN;
        private static final /* synthetic */ SeveralSupertypesWithSameConstructorPolicy[] $VALUES;

        static {
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray = new SeveralSupertypesWithSameConstructorPolicy[4];
            SeveralSupertypesWithSameConstructorPolicy[] severalSupertypesWithSameConstructorPolicyArray2 = severalSupertypesWithSameConstructorPolicyArray;
            severalSupertypesWithSameConstructorPolicyArray[0] = TAKE_FIRST_FOR_SUBTYPING = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[1] = FORCE_NOT_SUBTYPE = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[2] = CHECK_ANY_OF_THEM = new SeveralSupertypesWithSameConstructorPolicy();
            severalSupertypesWithSameConstructorPolicyArray[3] = INTERSECT_ARGUMENTS_AND_CHECK_AGAIN = new SeveralSupertypesWithSameConstructorPolicy();
            $VALUES = severalSupertypesWithSameConstructorPolicyArray;
        }

        public static SeveralSupertypesWithSameConstructorPolicy[] values() {
            return (SeveralSupertypesWithSameConstructorPolicy[])$VALUES.clone();
        }

        public static SeveralSupertypesWithSameConstructorPolicy valueOf(String string) {
            return Enum.valueOf(SeveralSupertypesWithSameConstructorPolicy.class, string);
        }
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER;
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER;
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;

        static {
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[3];
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray2 = lowerCapturedTypePolicyArray;
            lowerCapturedTypePolicyArray[0] = CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[1] = CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
            lowerCapturedTypePolicyArray[2] = SKIP_LOWER = new LowerCapturedTypePolicy();
            $VALUES = lowerCapturedTypePolicyArray;
        }

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String string) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, string);
        }
    }
}

