/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins;

import groovy.json.JsonSlurper;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import name.remal.building.gradle_plugins.API;
import name.remal.building.gradle_plugins.utils.UrlUtilsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;

@API
@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0016\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0013\u00a8\u0006\t"}, d2={"Lname/remal/building/gradle_plugins/GradleUpdatesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "doCheckGradleUpdates", "", "getGradleCurrentVersionInfo", "", "", "", "gradle-plugins"})
public class GradleUpdatesTask
extends DefaultTask {
    @TaskAction
    public void doCheckGradleUpdates() {
        try {
            GradleVersion currentVersion = GradleVersion.current();
            this.getLogger().info("Current Gradle version: {}", (Object)currentVersion.getVersion());
            Map<String, Object> info = this.getGradleCurrentVersionInfo();
            GradleVersion latestVersion = GradleVersion.version((String)String.valueOf(info.get("version")));
            this.getLogger().info("Latest Gradle version: {}", (Object)latestVersion.getVersion());
            if (currentVersion.compareTo(latestVersion) < 0) {
                this.getLogger().warn("New Gradle version is available: {} (downloadUrl: {})", (Object)latestVersion.getVersion(), info.get("downloadUrl"));
            }
            this.setDidWork(true);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> getGradleCurrentVersionInfo() {
        String jsonContent = UrlUtilsKt.getHttpBody(new URL("https://services.gradle.org/versions/current"));
        Object object = new JsonSlurper().parseText(jsonContent);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        }
        return (Map)object;
    }

    public GradleUpdatesTask() {
        this.setGroup("help");
        this.setDescription("Displays the if there is newer version of Gradle");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return !this.getProject().getGradle().getStartParameter().isOffline();
            }
        });
    }
}

