/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import name.remal.building.gradle_plugins.API;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@API
@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lname/remal/building/gradle_plugins/SimpleBuildCacheExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "value", "Ljava/io/File;", "baseDir", "getBaseDir", "()Ljava/io/File;", "setBaseDir", "(Ljava/io/File;)V", "dir", "getDir", "version", "getVersion", "()Ljava/lang/Object;", "setVersion", "(Ljava/lang/Object;)V", "Companion", "gradle-plugins"})
public class SimpleBuildCacheExtension {
    @NotNull
    private File baseDir;
    @NotNull
    private Object version;
    private static final String DEFAULT_VERSION = "1";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(@NotNull File value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        File file = value.getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "value.absoluteFile");
        this.baseDir = file;
    }

    @NotNull
    public Object getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, "<set-?>");
        this.version = object;
    }

    @NotNull
    public File getDir() {
        return FilesKt.resolve(this.getBaseDir(), CommonKt.encodeURIComponent(this.getVersion().toString()));
    }

    public SimpleBuildCacheExtension(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.baseDir = FilesKt.resolve(project.getProjectDir(), "build-cache");
        this.version = SimpleBuildCacheExtension.Companion.getDEFAULT_VERSION();
    }

    static {
        DEFAULT_VERSION = DEFAULT_VERSION;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lname/remal/building/gradle_plugins/SimpleBuildCacheExtension$Companion;", "", "()V", "DEFAULT_VERSION", "", "getDEFAULT_VERSION", "()Ljava/lang/String;", "gradle-plugins"})
    private static final class Companion {
        private final String getDEFAULT_VERSION() {
            return DEFAULT_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

