/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.classes_relocation;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import name.remal.building.gradle_plugins.artifact.Artifact;
import name.remal.building.gradle_plugins.artifact.CachedArtifactsCollection;
import name.remal.building.gradle_plugins.artifact.HasEntries;
import name.remal.building.gradle_plugins.classes_relocation.DoNotProcessAnnotationAdder;
import name.remal.building.gradle_plugins.classes_relocation.RelocatedClassesTransformer;
import name.remal.building.gradle_plugins.utils.AsmUtilsKt;
import name.remal.building.gradle_plugins.utils.CommonKt;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u0005*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lname/remal/building/gradle_plugins/classes_relocation/ClassesRelocator;", "", "classesDir", "Ljava/io/File;", "basePackage", "", "relocateAllConf", "Lorg/gradle/api/artifacts/Configuration;", "relocateUsedConf", "(Ljava/io/File;Ljava/lang/String;Lorg/gradle/api/artifacts/Configuration;Lorg/gradle/api/artifacts/Configuration;)V", "remappedClassNames", "", "getRemappedClassNames", "()Ljava/util/Map;", "remappedClassNamesMutable", "", "doRelocateClasses", "", "extractAll", "extractUsed", "remapClasses", "remapper", "Lorg/objectweb/asm/commons/Remapper;", "extractClass", "Lname/remal/building/gradle_plugins/artifact/HasEntries;", "className", "Companion", "gradle-plugins"})
public final class ClassesRelocator {
    private final Map<String, String> remappedClassNamesMutable;
    private final File classesDir;
    private final String basePackage;
    private final Configuration relocateAllConf;
    private final Configuration relocateUsedConf;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final Map<String, String> getRemappedClassNames() {
        return this.remappedClassNamesMutable;
    }

    public final void doRelocateClasses() {
        this.extractAll();
        this.extractUsed();
        this.remapClasses();
    }

    /*
     * WARNING - void declaration
     */
    private final void extractAll() {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Set resolvedArtifactFiles = this.relocateAllConf.resolve();
        if (resolvedArtifactFiles.isEmpty()) {
            return;
        }
        Iterable iterable = resolvedArtifactFiles;
        String string = "Extracting all classes from {}";
        Logger logger = ClassesRelocator.Companion.getLogger();
        void var3_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = it.getName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        logger.info(string, (Object)collection);
        Artifact outputArtifact = new Artifact(this.classesDir);
        Set set = resolvedArtifactFiles;
        Intrinsics.checkExpressionValueIsNotNull(set, "resolvedArtifactFiles");
        CachedArtifactsCollection artifacts = new CachedArtifactsCollection(set);
        Iterable $receiver$iv2 = artifacts.getClassNames();
        for (Object element$iv : $receiver$iv2) {
            String className = (String)element$iv;
            if (outputArtifact.getClassNames().contains(className)) {
                ClassesRelocator.Companion.getLogger().error("Already exists in sources {} - do not extract", (Object)className);
                continue;
            }
            ClassesRelocator.Companion.getLogger().debug("Extracting {}", (Object)className);
            this.remappedClassNamesMutable.computeIfAbsent(className, new Function<String, String>(className, this, outputArtifact, artifacts){
                final /* synthetic */ String $className;
                final /* synthetic */ ClassesRelocator this$0;
                final /* synthetic */ Artifact $outputArtifact$inlined;
                final /* synthetic */ CachedArtifactsCollection $artifacts$inlined;
                {
                    this.$className = string;
                    this.this$0 = classesRelocator;
                    this.$outputArtifact$inlined = artifact;
                    this.$artifacts$inlined = cachedArtifactsCollection;
                }

                @NotNull
                public final String apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return ClassesRelocator.extractClass$default(this.this$0, this.$artifacts$inlined, this.$className, null, 2, null);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void extractUsed() {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Set resolvedArtifactFiles = this.relocateUsedConf.resolve();
        if (resolvedArtifactFiles.isEmpty()) {
            return;
        }
        Iterable iterable = resolvedArtifactFiles;
        String string = "Extracting used only classes from {}";
        Logger logger = ClassesRelocator.Companion.getLogger();
        void var3_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = it.getName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        logger.info(string, (Object)collection);
        Set set = resolvedArtifactFiles;
        Intrinsics.checkExpressionValueIsNotNull(set, "resolvedArtifactFiles");
        CachedArtifactsCollection artifacts = new CachedArtifactsCollection(set);
        Artifact outputArtifact = new Artifact(this.classesDir);
        Set extractedClasses = new LinkedHashSet();
        Queue classesToExtract = new ArrayDeque();
        Remapper remapper2 = new Remapper(this, artifacts, outputArtifact, extractedClasses, classesToExtract){
            final /* synthetic */ ClassesRelocator this$0;
            final /* synthetic */ CachedArtifactsCollection $artifacts;
            final /* synthetic */ Artifact $outputArtifact;
            final /* synthetic */ Set $extractedClasses;
            final /* synthetic */ Queue $classesToExtract;

            @Nullable
            public String map(@NotNull String internalClassName) {
                String string;
                Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
                String className = string = StringsKt.replace$default(internalClassName, '/', '.', false, 4, null);
                if (this.$artifacts.getClassNames().contains(className)) {
                    if (this.$outputArtifact.getClassNames().contains(className)) {
                        name.remal.building.gradle_plugins.classes_relocation.ClassesRelocator$Companion.access$getLogger$p(ClassesRelocator.Companion).error("Already exists in sources {} - do not extract", (Object)className);
                    } else {
                        String resultClassName = ClassesRelocator.access$getBasePackage$p(this.this$0) + '.' + className;
                        if (this.$extractedClasses.add(className)) {
                            if (ClassesRelocator.access$getRemappedClassNamesMutable$p(this.this$0).put(className, resultClassName) == null) {
                                name.remal.building.gradle_plugins.classes_relocation.ClassesRelocator$Companion.access$getLogger$p(ClassesRelocator.Companion).debug("Extracting {}", (Object)className);
                                Collection collection = this.$classesToExtract;
                                collection.add(className);
                            } else {
                                name.remal.building.gradle_plugins.classes_relocation.ClassesRelocator$Companion.access$getLogger$p(ClassesRelocator.Companion).debug("Already relocated {} - do not extract", (Object)className);
                            }
                        }
                        return StringsKt.replace$default(resultClassName, '.', '/', false, 4, null);
                    }
                }
                return null;
            }
            {
                this.this$0 = $outer;
                this.$artifacts = $captured_local_variable$1;
                this.$outputArtifact = $captured_local_variable$2;
                this.$extractedClasses = $captured_local_variable$3;
                this.$classesToExtract = $captured_local_variable$4;
            }
        };
        this.remapClasses(remapper2);
        while ((String)classesToExtract.poll() != null) {
            String classToExtract;
            ClassesRelocator.Companion.getLogger().debug("Processing {}", (Object)classToExtract);
            this.extractClass(artifacts, classToExtract, remapper2);
        }
    }

    private final void remapClasses() {
        if (this.remappedClassNamesMutable.isEmpty()) {
            return;
        }
        this.remapClasses(new Remapper(this){
            final /* synthetic */ ClassesRelocator this$0;

            @Nullable
            public String map(@NotNull String internalClassName) {
                Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
                String string = (String)ClassesRelocator.access$getRemappedClassNamesMutable$p(this.this$0).get(StringsKt.replace$default(internalClassName, '/', '.', false, 4, null));
                return string != null ? StringsKt.replace$default(string, '.', '/', false, 4, null) : null;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String extractClass(@NotNull HasEntries $receiver, String className, Remapper remapper2) {
        Closeable closeable;
        String resultClassName = this.basePackage + '.' + className;
        File resultFile = new File(this.classesDir, CommonKt.classToResourcePath(resultClassName));
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = classWriter;
        classVisitor = new DoNotProcessAnnotationAdder(classVisitor);
        classVisitor = new RelocatedClassesTransformer(classVisitor);
        if (remapper2 != null) {
            classVisitor = new ClassRemapper(classVisitor, remapper2);
        }
        Closeable closeable2 = $receiver.openStreamForClass(className);
        boolean bl = false;
        try {
            InputStream inputStream = (InputStream)closeable2;
            new ClassReader(ByteStreamsKt.readBytes$default(inputStream, 0, 1, null)).accept(classVisitor, 0);
            Unit unit = Unit.INSTANCE;
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        File file = name.remal.building.gradle_plugins.dsl.CommonKt.createParentDirectories(resultFile);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "classWriter.toByteArray()");
        FilesKt.writeBytes(file, byArray);
        return resultClassName;
    }

    static /* bridge */ /* synthetic */ String extractClass$default(ClassesRelocator classesRelocator, HasEntries hasEntries, String string, Remapper remapper2, int n, Object object) {
        if ((n & 2) != 0) {
            remapper2 = null;
        }
        return classesRelocator.extractClass(hasEntries, string, remapper2);
    }

    /*
     * WARNING - void declaration
     */
    private final void remapClasses(Remapper remapper2) {
        File classedDir$iv = this.classesDir;
        Sequence $receiver$iv$iv = SequencesKt.filter(SequencesKt.filter(FilesKt.walk$default(classedDir$iv, null, 1, null), CommonKt.forEachClassFile.1.INSTANCE), CommonKt.forEachClassFile.2.INSTANCE);
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void classVisitor;
            Object element$iv$iv = iterator2.next();
            File classFile = (File)element$iv$iv;
            ClassWriter classWriter = new ClassWriter(0);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = classWriter;
            classVisitor.element = new ClassRemapper((ClassVisitor)classVisitor.element, remapper2);
            ClassVisitor logVisitor2 = new ClassVisitor((Ref.ObjectRef)classVisitor, AsmUtilsKt.getASM_API(), (ClassVisitor)classVisitor.element){
                final /* synthetic */ Ref.ObjectRef $classVisitor;

                public void visit(int version, int access, @Nullable String name, @Nullable String signature2, @Nullable String superName, @Nullable String[] interfaces) {
                    String string = name;
                    name.remal.building.gradle_plugins.classes_relocation.ClassesRelocator$Companion.access$getLogger$p(ClassesRelocator.Companion).debug("Processing {}", string != null ? StringsKt.replace$default(string, '/', '.', false, 4, null) : null);
                    super.visit(version, access, name, signature2, superName, interfaces);
                }
                {
                    this.$classVisitor = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            };
            new ClassReader(FilesKt.readBytes(classFile)).accept(logVisitor2, 0);
            byte[] byArray = classWriter.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "classWriter.toByteArray()");
            FilesKt.writeBytes(classFile, byArray);
        }
    }

    public ClassesRelocator(@NotNull File classesDir, @NotNull String basePackage, @NotNull Configuration relocateAllConf2, @NotNull Configuration relocateUsedConf2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(classesDir, "classesDir");
        Intrinsics.checkParameterIsNotNull(basePackage, "basePackage");
        Intrinsics.checkParameterIsNotNull(relocateAllConf2, "relocateAllConf");
        Intrinsics.checkParameterIsNotNull(relocateUsedConf2, "relocateUsedConf");
        this.classesDir = classesDir;
        this.basePackage = basePackage;
        this.relocateAllConf = relocateAllConf2;
        this.relocateUsedConf = relocateUsedConf2;
        ClassesRelocator classesRelocator = this;
        classesRelocator.remappedClassNamesMutable = map2 = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(ClassesRelocator.class);
    }

    @NotNull
    public static final /* synthetic */ String access$getBasePackage$p(ClassesRelocator $this) {
        return $this.basePackage;
    }

    @NotNull
    public static final /* synthetic */ Map access$getRemappedClassNamesMutable$p(ClassesRelocator $this) {
        return $this.remappedClassNamesMutable;
    }

    private static final Logger getLogger() {
        return ClassesRelocator.Companion.getLogger();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lname/remal/building/gradle_plugins/classes_relocation/ClassesRelocator$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger$annotations", "getLogger", "()Lorg/slf4j/Logger;", "gradle-plugins"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void logger$annotations() {
        }

        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

