/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.generate_sources;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import name.remal.building.gradle_plugins.API;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import name.remal.building.gradle_plugins.dsl.JavaProjectKt;
import name.remal.building.gradle_plugins.dsl.TaskUtilsKt;
import name.remal.building.gradle_plugins.generate_sources.BaseSourceGenerator;
import name.remal.building.gradle_plugins.utils.GroovyUtilsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001eH\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00062\f\b\u0001\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001eH\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\f\b\u0001\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030 H\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J\u001c\u0010#\u001a\u00020\u00192\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00190\u001eH\u0016J\u0016\u0010#\u001a\u00020\u00192\f\b\u0001\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u0016\u0010#\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0!H\u0016J$\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001eH\u0016J\u001e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00062\f\b\u0001\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u001e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J\b\u0010&\u001a\u00020\u0019H\u0015R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\f8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\n\u00a8\u0006'"}, d2={"Lname/remal/building/gradle_plugins/generate_sources/GenerateSourcesTask;", "SourceGeneratorType", "Lname/remal/building/gradle_plugins/generate_sources/BaseSourceGenerator;", "Lorg/gradle/api/DefaultTask;", "()V", "classFileExtension", "", "getClassFileExtension", "()Ljava/lang/String;", "setClassFileExtension", "(Ljava/lang/String;)V", "outputDir", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "textFilesCharset", "Ljava/nio/charset/Charset;", "getTextFilesCharset", "()Ljava/nio/charset/Charset;", "textFilesEncoding", "getTextFilesEncoding", "setTextFilesEncoding", "addSourceGeneration", "", "generator", "(Lname/remal/building/gradle_plugins/generate_sources/BaseSourceGenerator;)V", "fileName", "action", "Lkotlin/Function1;", "Ljava/io/Writer;", "Lgroovy/lang/Closure;", "Ljava/util/function/Consumer;", "packageName", "addSourcesGeneration", "addTextResourceGeneration", "fileRelativePath", "createOutputDirectory", "gradle-plugins"})
public class GenerateSourcesTask<SourceGeneratorType extends BaseSourceGenerator>
extends DefaultTask {
    @OutputDirectory
    @NotNull
    public File outputDir;
    @NotNull
    public String classFileExtension;
    @Nullable
    private String textFilesEncoding;

    @NotNull
    public File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("outputDir");
        }
        return file;
    }

    public void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "<set-?>");
        this.outputDir = file;
    }

    @NotNull
    public String getClassFileExtension() {
        String string = this.classFileExtension;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("classFileExtension");
        }
        return string;
    }

    public void setClassFileExtension(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.classFileExtension = string;
    }

    @Nullable
    public String getTextFilesEncoding() {
        return this.textFilesEncoding;
    }

    public void setTextFilesEncoding(@Nullable String string) {
        this.textFilesEncoding = string;
    }

    @NotNull
    public Charset getTextFilesCharset() {
        String string = this.getTextFilesEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        Charset charset = Charset.forName(string);
        Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(textFilesEncoding ?: ENCODING)");
        return charset;
    }

    @TaskAction
    protected void createOutputDirectory() {
        CommonKt.createDirectories(CommonKt.forceDelete(this.getOutputDir()));
    }

    public void addSourcesGeneration(@NotNull Function1<? super File, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.doLast((Action)new Action<Task>(this, action){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ Function1 $action;

            public final void execute(Task it) {
                this.$action.invoke(this.this$0.getOutputDir());
                this.this$0.setDidWork(true);
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$action = function1;
            }
        });
    }

    public void addSourcesGeneration(@NotNull Consumer<File> action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourcesGeneration((Function1<File, Unit>)new Function1<File, Unit>(action){

            public final void invoke(@NotNull File p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                ((Consumer)this.receiver).accept(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Consumer.class);
            }

            public final String getName() {
                return "accept";
            }

            public final String getSignature() {
                return "accept(Ljava/lang/Object;)V";
            }
        });
    }

    public void addSourcesGeneration(@DelegatesTo(value=GenerateSourcesTask.class, strategy=1) @NotNull Closure<?> action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourcesGeneration((Function1<File, Unit>)new Function1<File, Unit>(this, action){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ Closure $action;

            public final void invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                GroovyUtilsKt.delegateCall(this.$action, (Object)((Object)this.this$0), it);
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$action = closure;
                super(1);
            }
        });
    }

    public void addTextResourceGeneration(@NotNull String fileRelativePath, @NotNull Function1<? super Writer, Unit> action) {
        Intrinsics.checkParameterIsNotNull(fileRelativePath, "fileRelativePath");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourcesGeneration((Function1<File, Unit>)new Function1<File, Unit>(this, fileRelativePath, action){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ String $fileRelativePath;
            final /* synthetic */ Function1 $action;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull File outputDir2) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(outputDir2, "outputDir");
                File classFile = FilesKt.resolve(outputDir2, this.$fileRelativePath).getAbsoluteFile();
                this.this$0.getLogger().info("Generating {}", (Object)classFile);
                Object object = CommonKt.createParentDirectories(classFile);
                object = new FileOutputStream((File)object);
                Charset charset = this.this$0.getTextFilesCharset();
                Object object2 = object;
                object2 = new OutputStreamWriter((OutputStream)object2, charset);
                int n = 8192;
                object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                Function1 block$iv = this.$action;
                boolean closed$iv = false;
                try {
                    R r = block$iv.invoke($receiver$iv);
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv = true;
                        try {
                            $receiver$iv.close();
                        }
                        catch (Exception closeException$iv) {
                            e$iv.addSuppressed(closeException$iv);
                        }
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv) {
                            $receiver$iv.close();
                        }
                        throw throwable;
                    }
                }
                $receiver$iv.close();
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$fileRelativePath = string;
                this.$action = function1;
                super(1);
            }
        });
    }

    public void addTextResourceGeneration(@NotNull String fileRelativePath, @NotNull Consumer<Writer> action) {
        Intrinsics.checkParameterIsNotNull(fileRelativePath, "fileRelativePath");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addTextResourceGeneration(fileRelativePath, (Function1<Writer, Unit>)new Function1<Writer, Unit>(action){

            public final void invoke(@NotNull Writer p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                ((Consumer)this.receiver).accept(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Consumer.class);
            }

            public final String getName() {
                return "accept";
            }

            public final String getSignature() {
                return "accept(Ljava/lang/Object;)V";
            }
        });
    }

    public void addTextResourceGeneration(@NotNull String fileRelativePath, @DelegatesTo(value=GenerateSourcesTask.class, strategy=1) @NotNull Closure<?> action) {
        Intrinsics.checkParameterIsNotNull(fileRelativePath, "fileRelativePath");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addTextResourceGeneration(fileRelativePath, (Function1<Writer, Unit>)new Function1<Writer, Unit>(this, action){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ Closure $action;

            public final void invoke(@NotNull Writer it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                GroovyUtilsKt.delegateCall(this.$action, (Object)((Object)this.this$0), it);
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$action = closure;
                super(1);
            }
        });
    }

    public void addSourceGeneration(@NotNull String packageName, @NotNull String fileName, @NotNull Function1<? super Writer, Unit> action) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        CharSequence charSequence = packageName;
        if (charSequence.length() > 0) {
            $receiver.append(StringsKt.replace$default(packageName, '.', '/', false, 4, null)).append('/');
        }
        $receiver.append(StringsKt.replace$default(fileName, '.', '$', false, 4, null)).append('.').append(this.getClassFileExtension());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        String fileRelativePath = string;
        this.addTextResourceGeneration(fileRelativePath, action);
    }

    public void addSourceGeneration(@NotNull String fileName, @NotNull Function1<? super Writer, Unit> action) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourceGeneration(JavaProjectKt.getJavaPackageName(this.getProject()), fileName, action);
    }

    public void addSourceGeneration(@NotNull String packageName, @NotNull String fileName, @NotNull Consumer<Writer> action) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourceGeneration(packageName, fileName, (Function1<Writer, Unit>)new Function1<Writer, Unit>(action){

            public final void invoke(@NotNull Writer p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                ((Consumer)this.receiver).accept(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Consumer.class);
            }

            public final String getName() {
                return "accept";
            }

            public final String getSignature() {
                return "accept(Ljava/lang/Object;)V";
            }
        });
    }

    public void addSourceGeneration(@NotNull String fileName, @NotNull Consumer<Writer> action) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourceGeneration(JavaProjectKt.getJavaPackageName(this.getProject()), fileName, action);
    }

    public void addSourceGeneration(@NotNull String packageName, @NotNull String fileName, @DelegatesTo(value=GenerateSourcesTask.class, strategy=1) @NotNull Closure<?> action) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourceGeneration(packageName, fileName, (Function1<Writer, Unit>)new Function1<Writer, Unit>(this, action){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ Closure $action;

            public final void invoke(@NotNull Writer it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                GroovyUtilsKt.delegateCall(this.$action, (Object)((Object)this.this$0), it);
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$action = closure;
                super(1);
            }
        });
    }

    public void addSourceGeneration(@NotNull String fileName, @DelegatesTo(value=GenerateSourcesTask.class, strategy=1) @NotNull Closure<?> action) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(action, "action");
        this.addSourceGeneration(JavaProjectKt.getJavaPackageName(this.getProject()), fileName, action);
    }

    public void addSourceGeneration(@NotNull SourceGeneratorType generator) {
        Intrinsics.checkParameterIsNotNull(generator, "generator");
        this.addSourceGeneration(((BaseSourceGenerator)generator).getPackageName(), ((BaseSourceGenerator)generator).getFileName(), (Function1<Writer, Unit>)new Function1<Writer, Unit>(this, generator){
            final /* synthetic */ GenerateSourcesTask this$0;
            final /* synthetic */ BaseSourceGenerator $generator;

            public final void invoke(@NotNull Writer writer) {
                Intrinsics.checkParameterIsNotNull(writer, "writer");
                Project project = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull(project, "project");
                this.$generator.accept(project, writer);
            }
            {
                this.this$0 = generateSourcesTask2;
                this.$generator = baseSourceGenerator;
                super(1);
            }
        });
    }

    public GenerateSourcesTask() {
        TaskUtilsKt.disableCache((Task)this);
    }
}

