/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.utils;

import org.gradle.api.JavaVersion;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public interface Compatibility {
    public static final JavaVersion DEFAULT_MIN_JAVA_VERSION = JavaVersion.VERSION_1_8;
    public static final GradleVersion DEFAULT_MIN_GRADLE_VERSION = GradleVersion.version((String)"3.5");

    public static void checkMinJavaVersion() {
        Compatibility.checkMinJavaVersion(DEFAULT_MIN_JAVA_VERSION);
    }

    public static void checkMinJavaVersion(@NotNull JavaVersion version) {
        JavaVersion current = JavaVersion.current();
        if (current.compareTo((Enum)version) < 0) {
            throw new TooOldJavaVersion(current.toString(), version.toString());
        }
    }

    public static void checkMinGradleVersion() {
        Compatibility.checkMinGradleVersion(DEFAULT_MIN_GRADLE_VERSION);
    }

    public static void checkMinGradleVersion(@NotNull GradleVersion version) {
        GradleVersion current = GradleVersion.current();
        if (current.compareTo(version) < 0) {
            throw new TooOldGradleVersion(current.getVersion(), version.getVersion());
        }
    }

    public static class TooOldGradleVersion
    extends RuntimeException {
        public TooOldGradleVersion(String currentVersion, String requiredVersion) {
            super("Too old Gradle version - " + currentVersion + ", required - " + requiredVersion);
        }
    }

    public static class TooOldJavaVersion
    extends RuntimeException {
        public TooOldJavaVersion(String currentVersion, String requiredVersion) {
            super("Too old Java version - " + currentVersion + ", required - " + requiredVersion);
        }
    }
}

