/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;

public abstract class ObjectLoader {
    public abstract int getType();

    public abstract long getSize();

    public boolean isLarge() {
        try {
            this.getCachedBytes();
            return false;
        }
        catch (LargeObjectException tooBig) {
            return true;
        }
    }

    public final byte[] getBytes() throws LargeObjectException {
        return ObjectLoader.cloneArray(this.getCachedBytes());
    }

    public final byte[] getBytes(int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        byte[] cached = this.getCachedBytes(sizeLimit);
        try {
            return ObjectLoader.cloneArray(cached);
        }
        catch (OutOfMemoryError tooBig) {
            throw new LargeObjectException.OutOfMemory(tooBig);
        }
    }

    public abstract byte[] getCachedBytes() throws LargeObjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCachedBytes(int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        if (!this.isLarge()) {
            return this.getCachedBytes();
        }
        try (ObjectStream in = this.openStream();){
            byte[] buf;
            long sz = in.getSize();
            if ((long)sizeLimit < sz) {
                throw new LargeObjectException.ExceedsLimit(sizeLimit, sz);
            }
            if (Integer.MAX_VALUE < sz) {
                throw new LargeObjectException.ExceedsByteArrayLimit();
            }
            try {
                buf = new byte[(int)sz];
            }
            catch (OutOfMemoryError notEnoughHeap) {
                throw new LargeObjectException.OutOfMemory(notEnoughHeap);
            }
            IO.readFully(in, buf, 0, buf.length);
            byte[] byArray = buf;
            return byArray;
        }
    }

    public abstract ObjectStream openStream() throws MissingObjectException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream out) throws MissingObjectException, IOException {
        block7: {
            if (this.isLarge()) {
                try (ObjectStream in = this.openStream();){
                    int n;
                    long sz = in.getSize();
                    byte[] tmp = new byte[8192];
                    for (long copied = 0L; copied < sz; copied += (long)n) {
                        n = in.read(tmp);
                        if (n < 0) {
                            throw new EOFException();
                        }
                        out.write(tmp, 0, n);
                    }
                    if (0 <= in.read()) {
                        throw new EOFException();
                    }
                    break block7;
                }
            }
            out.write(this.getCachedBytes());
        }
    }

    private static byte[] cloneArray(byte[] data2) {
        byte[] copy = new byte[data2.length];
        System.arraycopy(data2, 0, copy, 0, data2.length);
        return copy;
    }

    public static class SmallObject
    extends ObjectLoader {
        private final int type;
        private final byte[] data;

        public SmallObject(int type2, byte[] data2) {
            this.type = type2;
            this.data = data2;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public long getSize() {
            return this.getCachedBytes().length;
        }

        @Override
        public boolean isLarge() {
            return false;
        }

        @Override
        public byte[] getCachedBytes() {
            return this.data;
        }

        @Override
        public ObjectStream openStream() {
            return new ObjectStream.SmallStream(this);
        }
    }
}

