/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig;

import java.io.File;
import java.io.OutputStream;
import org.jtwig.JtwigModel;
import org.jtwig.environment.DefaultEnvironmentConfiguration;
import org.jtwig.environment.Environment;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentFactory;
import org.jtwig.environment.EnvironmentHolder;
import org.jtwig.escape.EscapeEngine;
import org.jtwig.model.tree.Node;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.context.RenderContext;
import org.jtwig.render.context.RenderContextHolder;
import org.jtwig.render.context.model.BlockContext;
import org.jtwig.render.listeners.RenderStage;
import org.jtwig.renderable.RenderResult;
import org.jtwig.renderable.StreamRenderResult;
import org.jtwig.renderable.StringBuilderRenderResult;
import org.jtwig.resource.reference.ResourceReference;
import org.jtwig.value.context.IsolateParentValueContext;
import org.jtwig.value.context.JtwigModelValueContext;
import org.jtwig.value.context.MapValueContext;
import org.jtwig.value.context.ValueContext;

public class JtwigTemplate {
    public static final EnvironmentFactory ENVIRONMENT_FACTORY = new EnvironmentFactory();
    private final ResourceReference resource;
    private final Environment environment;

    public static JtwigTemplate inlineTemplate(String template) {
        return JtwigTemplate.inlineTemplate(template, new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate inlineTemplate(String template, EnvironmentConfiguration configuration) {
        return new JtwigTemplate(ENVIRONMENT_FACTORY.create(configuration), new ResourceReference("string", template));
    }

    public static JtwigTemplate classpathTemplate(String location2) {
        return JtwigTemplate.classpathTemplate(location2, new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate classpathTemplate(String location2, EnvironmentConfiguration environmentConfiguration) {
        ResourceReference resourceReference = new ResourceReference("classpath", location2);
        Environment environment = ENVIRONMENT_FACTORY.create(environmentConfiguration);
        return new JtwigTemplate(environment, resourceReference);
    }

    public static JtwigTemplate fileTemplate(String filename, EnvironmentConfiguration environmentConfiguration) {
        Environment environment = ENVIRONMENT_FACTORY.create(environmentConfiguration);
        ResourceReference resourceReference = new ResourceReference("file", filename);
        return new JtwigTemplate(environment, resourceReference);
    }

    public static JtwigTemplate fileTemplate(String filename) {
        return JtwigTemplate.fileTemplate(filename, (EnvironmentConfiguration)new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate fileTemplate(File path, EnvironmentConfiguration environmentConfiguration) {
        return JtwigTemplate.fileTemplate(path.getAbsolutePath(), environmentConfiguration);
    }

    public static JtwigTemplate fileTemplate(File path) {
        return JtwigTemplate.fileTemplate(path, (EnvironmentConfiguration)new DefaultEnvironmentConfiguration());
    }

    public JtwigTemplate(Environment environment, ResourceReference resource) {
        this.resource = resource;
        this.environment = environment;
    }

    public String render(JtwigModel model) {
        StringBuilderRenderResult result2 = new StringBuilderRenderResult();
        this.render(model, result2);
        return result2.content();
    }

    public void render(JtwigModel model, OutputStream outputStream) {
        StreamRenderResult result2 = new StreamRenderResult(outputStream, this.environment.getRenderEnvironment().getDefaultOutputCharset());
        this.render(model, result2);
    }

    private void render(JtwigModel model, RenderResult renderResult) {
        RenderContext renderContext = RenderContext.create().start(ValueContext.class, new IsolateParentValueContext(new JtwigModelValueContext(model), MapValueContext.newContext())).start(EscapeEngine.class, this.environment.getEscapeEnvironment().getInitialEscapeEngine()).start(ResourceReference.class, this.resource).start(BlockContext.class, BlockContext.newContext());
        EnvironmentHolder.set(this.environment);
        RenderContextHolder.set(renderContext);
        RenderRequest renderRequest = new RenderRequest(renderContext, this.environment);
        this.environment.getRenderEnvironment().getRenderListeners().trigger(RenderStage.PRE_TEMPLATE_RENDER, renderRequest);
        this.environment.getRenderEnvironment().getRenderListeners().trigger(RenderStage.PRE_RESOURCE_RENDER, renderRequest);
        Node node = this.environment.getParser().parse(this.environment, this.resource);
        this.environment.getRenderEnvironment().getRenderNodeService().render(renderRequest, node).appendTo(renderResult);
        this.environment.getRenderEnvironment().getRenderListeners().trigger(RenderStage.POST_RESOURCE_RENDER, renderRequest);
        this.environment.getRenderEnvironment().getRenderListeners().trigger(RenderStage.POST_TEMPLATE_RENDER, renderRequest);
        renderContext.end(ValueContext.class);
        renderContext.end(EscapeEngine.class);
        renderContext.end(ResourceReference.class);
        renderContext.end(BlockContext.class);
        EnvironmentHolder.remove();
        RenderContextHolder.remove();
    }
}

