/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.environment;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.jtwig.environment.DefaultEnvironmentConfiguration;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.and.AndEscapeEngineConfigurationBuilder;
import org.jtwig.environment.and.AndJtwigParserConfigurationBuilder;
import org.jtwig.environment.and.AndPropertyResolverConfigurationBuilder;
import org.jtwig.environment.and.AndRenderConfigurationBuilder;
import org.jtwig.environment.and.AndResourceConfigurationBuilder;
import org.jtwig.environment.and.AndValueConfigurationBuilder;
import org.jtwig.environment.initializer.EnvironmentInitializer;
import org.jtwig.extension.Extension;
import org.jtwig.functions.JtwigFunction;
import org.jtwig.render.expression.calculator.enumerated.EnumerationListStrategy;
import org.jtwig.util.builder.ListBuilder;
import org.jtwig.util.builder.MapBuilder;

public class EnvironmentConfigurationBuilder
implements Builder<EnvironmentConfiguration> {
    private final MapBuilder<EnvironmentConfigurationBuilder, String, Object> parameters;
    private final ListBuilder<EnvironmentConfigurationBuilder, Extension> extensions;
    private final ListBuilder<EnvironmentConfigurationBuilder, JtwigFunction> functions;
    private final ListBuilder<EnvironmentConfigurationBuilder, EnumerationListStrategy> enumerationListStrategies;
    private final ListBuilder<EnvironmentConfigurationBuilder, EnvironmentInitializer> initializers;
    private final AndRenderConfigurationBuilder renderConfiguration;
    private final AndJtwigParserConfigurationBuilder jtwigParserConfigurationBuilder;
    private final AndResourceConfigurationBuilder resourceConfigurationBuilder;
    private final AndValueConfigurationBuilder valueConfigurationBuilder;
    private final AndEscapeEngineConfigurationBuilder escapeEngineConfigurationBuilder;
    private final AndPropertyResolverConfigurationBuilder propertyResolverConfigurationBuilder;

    public static EnvironmentConfigurationBuilder configuration() {
        return new EnvironmentConfigurationBuilder(new DefaultEnvironmentConfiguration());
    }

    public EnvironmentConfigurationBuilder() {
        this.functions = new ListBuilder(this);
        this.renderConfiguration = new AndRenderConfigurationBuilder(this);
        this.jtwigParserConfigurationBuilder = new AndJtwigParserConfigurationBuilder(this);
        this.resourceConfigurationBuilder = new AndResourceConfigurationBuilder(this);
        this.escapeEngineConfigurationBuilder = new AndEscapeEngineConfigurationBuilder(this);
        this.propertyResolverConfigurationBuilder = new AndPropertyResolverConfigurationBuilder(this);
        this.enumerationListStrategies = new ListBuilder(this);
        this.valueConfigurationBuilder = new AndValueConfigurationBuilder(this);
        this.extensions = new ListBuilder(this);
        this.parameters = new MapBuilder(this);
        this.initializers = new ListBuilder(this);
    }

    public EnvironmentConfigurationBuilder(EnvironmentConfiguration prototype) {
        this.functions = new ListBuilder<EnvironmentConfigurationBuilder, JtwigFunction>(this, prototype.getFunctions());
        this.renderConfiguration = new AndRenderConfigurationBuilder(prototype.getRenderConfiguration(), this);
        this.jtwigParserConfigurationBuilder = new AndJtwigParserConfigurationBuilder(prototype.getJtwigParserConfiguration(), this);
        this.resourceConfigurationBuilder = new AndResourceConfigurationBuilder(prototype.getResourceConfiguration(), this);
        this.escapeEngineConfigurationBuilder = new AndEscapeEngineConfigurationBuilder(prototype.getEscapeConfiguration(), this);
        this.propertyResolverConfigurationBuilder = new AndPropertyResolverConfigurationBuilder(prototype.getPropertyResolverConfiguration(), this);
        this.enumerationListStrategies = new ListBuilder<EnvironmentConfigurationBuilder, EnumerationListStrategy>(this, prototype.getEnumerationStrategies());
        this.valueConfigurationBuilder = new AndValueConfigurationBuilder(prototype.getValueConfiguration(), this);
        this.extensions = new ListBuilder<EnvironmentConfigurationBuilder, Extension>(this, prototype.getExtensions());
        this.parameters = new MapBuilder<EnvironmentConfigurationBuilder, String, Object>(this, prototype.getParameters());
        this.initializers = new ListBuilder<EnvironmentConfigurationBuilder, EnvironmentInitializer>(this, prototype.getInitializers());
    }

    @Override
    public EnvironmentConfiguration build() {
        return new EnvironmentConfiguration(this.resourceConfigurationBuilder.build(), (Collection<EnumerationListStrategy>)this.enumerationListStrategies.build(), this.jtwigParserConfigurationBuilder.build(), this.valueConfigurationBuilder.build(), this.renderConfiguration.build(), this.escapeEngineConfigurationBuilder.build(), this.propertyResolverConfigurationBuilder.build(), (Collection<JtwigFunction>)this.functions.build(), (Map<String, Object>)this.parameters.build(), (Collection<Extension>)this.extensions.build(), (List<EnvironmentInitializer>)this.initializers.build());
    }

    public AndJtwigParserConfigurationBuilder parser() {
        return this.jtwigParserConfigurationBuilder;
    }

    public ListBuilder<EnvironmentConfigurationBuilder, JtwigFunction> functions() {
        return this.functions;
    }

    public AndRenderConfigurationBuilder render() {
        return this.renderConfiguration;
    }

    public AndResourceConfigurationBuilder resources() {
        return this.resourceConfigurationBuilder;
    }

    public AndPropertyResolverConfigurationBuilder propertyResolver() {
        return this.propertyResolverConfigurationBuilder;
    }

    public AndValueConfigurationBuilder value() {
        return this.valueConfigurationBuilder;
    }

    public AndEscapeEngineConfigurationBuilder escape() {
        return this.escapeEngineConfigurationBuilder;
    }

    public ListBuilder<EnvironmentConfigurationBuilder, EnumerationListStrategy> enumerationStrategies() {
        return this.enumerationListStrategies;
    }

    public ListBuilder<EnvironmentConfigurationBuilder, EnvironmentInitializer> initializers() {
        return this.initializers;
    }

    public MapBuilder<EnvironmentConfigurationBuilder, String, Object> parameters() {
        return this.parameters;
    }

    public ListBuilder<EnvironmentConfigurationBuilder, Extension> extensions() {
        return this.extensions;
    }
}

