/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.environment;

import org.jtwig.environment.Environment;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentConfigurationBuilder;
import org.jtwig.environment.initializer.EnvironmentInitializer;
import org.jtwig.escape.environment.EscapeEnvironmentFactory;
import org.jtwig.extension.Extension;
import org.jtwig.functions.environment.FunctionResolverFactory;
import org.jtwig.parser.JtwigParserFactory;
import org.jtwig.property.environment.PropertyResolverEnvironmentFactory;
import org.jtwig.render.environment.RenderEnvironmentFactory;
import org.jtwig.render.expression.calculator.enumerated.environment.EnumerationListStrategyFactory;
import org.jtwig.resource.environment.ResourceEnvironmentFactory;
import org.jtwig.value.environment.ValueEnvironmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentFactory {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentFactory.class);
    private final JtwigParserFactory jtwigParserFactory;
    private final ResourceEnvironmentFactory resourceEnvironmentFactory;
    private final RenderEnvironmentFactory renderEnvironmentFactory;
    private final FunctionResolverFactory functionResolverFactory;
    private final PropertyResolverEnvironmentFactory propertyResolverFactory;
    private final ValueEnvironmentFactory valueEnvironmentFactory;
    private final EnumerationListStrategyFactory enumerationListStrategyFactory;
    private final EscapeEnvironmentFactory escapeEnvironmentFactory;

    public EnvironmentFactory() {
        this(new JtwigParserFactory(), new ResourceEnvironmentFactory(), new RenderEnvironmentFactory(), new FunctionResolverFactory(), new PropertyResolverEnvironmentFactory(), new ValueEnvironmentFactory(), new EnumerationListStrategyFactory(), new EscapeEnvironmentFactory());
    }

    public EnvironmentFactory(JtwigParserFactory jtwigParserFactory, ResourceEnvironmentFactory resourceEnvironmentFactory, RenderEnvironmentFactory renderEnvironmentFactory, FunctionResolverFactory functionResolverFactory, PropertyResolverEnvironmentFactory propertyResolverFactory, ValueEnvironmentFactory valueEnvironmentFactory, EnumerationListStrategyFactory enumerationListStrategyFactory, EscapeEnvironmentFactory escapeEnvironmentFactory) {
        this.jtwigParserFactory = jtwigParserFactory;
        this.resourceEnvironmentFactory = resourceEnvironmentFactory;
        this.renderEnvironmentFactory = renderEnvironmentFactory;
        this.functionResolverFactory = functionResolverFactory;
        this.propertyResolverFactory = propertyResolverFactory;
        this.enumerationListStrategyFactory = enumerationListStrategyFactory;
        this.valueEnvironmentFactory = valueEnvironmentFactory;
        this.escapeEnvironmentFactory = escapeEnvironmentFactory;
    }

    public Environment create(EnvironmentConfiguration environmentConfiguration) {
        EnvironmentConfiguration configuration = environmentConfiguration;
        if (!environmentConfiguration.getExtensions().isEmpty()) {
            log.info("Jtwig base configuration extended with:");
            EnvironmentConfigurationBuilder builder = new EnvironmentConfigurationBuilder(environmentConfiguration);
            for (Extension extension : environmentConfiguration.getExtensions()) {
                log.info("- {}", (Object)extension.getClass().getSimpleName());
                extension.configure(builder);
            }
            configuration = builder.build();
        }
        Environment instance = new Environment(this.jtwigParserFactory.create(configuration.getJtwigParserConfiguration()), configuration.getParameters(), this.resourceEnvironmentFactory.create(configuration.getResourceConfiguration()), this.functionResolverFactory.create(configuration.getFunctions()), this.propertyResolverFactory.create(configuration.getPropertyResolverConfiguration()), this.renderEnvironmentFactory.create(configuration.getRenderConfiguration()), this.valueEnvironmentFactory.create(configuration.getValueConfiguration()), this.enumerationListStrategyFactory.create(configuration.getEnumerationStrategies()), this.escapeEnvironmentFactory.create(configuration.getEscapeConfiguration()));
        if (!configuration.getInitializers().isEmpty()) {
            log.info("Jtwig pre-loading resources");
            for (EnvironmentInitializer initializer2 : configuration.getInitializers()) {
                initializer2.initialize(instance);
            }
        }
        return instance;
    }
}

