/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.util.FunctionValueUtils;

public class BatchFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "batch";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.minimumNumberOfArguments(2).maximumNumberOfArguments(3);
        int groupSize = FunctionValueUtils.getNumber(request, 1).intValue();
        if (request.getNumberOfArguments() == 3) {
            return this.batch(request, 0, groupSize, request.get(2));
        }
        return this.batch(request, 0, groupSize);
    }

    private List<List<Object>> batch(FunctionRequest request, int index, int groupSize) {
        Iterator<Object> iterator2 = FunctionValueUtils.getCollection(request, index).iterator();
        ArrayList<List<Object>> result2 = new ArrayList<List<Object>>();
        while (iterator2.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (!iterator2.hasNext()) continue;
                batch.add(iterator2.next());
            }
            result2.add(batch);
        }
        return result2;
    }

    public List<List<Object>> batch(FunctionRequest request, int index, int groupSize, Object padding) {
        Iterator<Object> iterator2 = FunctionValueUtils.getCollection(request, index).iterator();
        ArrayList<List<Object>> result2 = new ArrayList<List<Object>>();
        while (iterator2.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (iterator2.hasNext()) {
                    batch.add(iterator2.next());
                    continue;
                }
                batch.add(padding);
            }
            result2.add(batch);
        }
        return result2;
    }
}

