/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.math;

import java.math.BigDecimal;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.util.FunctionValueUtils;

public class RoundFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "round";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.maximumNumberOfArguments(3).minimumNumberOfArguments(1);
        int precision = 0;
        RoundStrategy roundingMode = RoundStrategy.COMMON;
        if (request.getNumberOfArguments() == 3) {
            precision = FunctionValueUtils.getNumber(request, 1).intValue();
            roundingMode = RoundStrategy.valueOf(FunctionValueUtils.getString(request, 2).toUpperCase());
        }
        if (request.getNumberOfArguments() == 2) {
            roundingMode = RoundStrategy.valueOf(FunctionValueUtils.getString(request, 1).toUpperCase());
        }
        BigDecimal number = FunctionValueUtils.getNumber(request, 0);
        return roundingMode.round(number, precision);
    }

    private static class StaticRound
    implements Round {
        private final int roundingMode;

        StaticRound(int roundingMode) {
            this.roundingMode = roundingMode;
        }

        @Override
        public BigDecimal round(BigDecimal number, int precision) {
            return number.setScale(precision, this.roundingMode);
        }
    }

    private static interface Round {
        public BigDecimal round(BigDecimal var1, int var2);
    }

    public static enum RoundStrategy {
        COMMON(new StaticRound(4)),
        CEIL(new StaticRound(2)),
        FLOOR(new StaticRound(3));

        private Round round;

        private RoundStrategy(Round round) {
            this.round = round;
        }

        public BigDecimal round(BigDecimal number, int precision) {
            return this.round.round(number, precision);
        }
    }
}

