/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.string;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.util.FunctionValueUtils;

public class NumberFormatFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "number_format";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.minimumNumberOfArguments(1).maximumNumberOfArguments(4);
        BigDecimal number = FunctionValueUtils.getNumber(request, 0);
        switch (request.getNumberOfArguments()) {
            case 2: {
                return this.numberFormat(number, FunctionValueUtils.getNumber(request, 1), null, null);
            }
            case 3: {
                return this.numberFormat(number, FunctionValueUtils.getNumber(request, 1), FunctionValueUtils.getString(request, 2), null);
            }
            case 4: {
                return this.numberFormat(number, FunctionValueUtils.getNumber(request, 1), FunctionValueUtils.getString(request, 2), FunctionValueUtils.getString(request, 3));
            }
        }
        return this.numberFormat(number, null, null, null);
    }

    private String numberFormat(Object numberArg, BigDecimal fractionDigits, String decimalSeparator, String groupingSeparator) {
        Object number = numberArg == null ? Integer.valueOf(0) : numberArg;
        DecimalFormat numberFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
        if (fractionDigits != null) {
            numberFormat.setMaximumFractionDigits(fractionDigits.intValue());
            numberFormat.setMinimumFractionDigits(fractionDigits.intValue());
        }
        if (decimalSeparator != null && !decimalSeparator.isEmpty()) {
            decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charAt(0));
        } else {
            decimalFormatSymbols.setDecimalSeparator('.');
        }
        if (groupingSeparator != null && !groupingSeparator.isEmpty()) {
            decimalFormatSymbols.setGroupingSeparator(groupingSeparator.charAt(0));
        } else {
            numberFormat.setGroupingUsed(false);
        }
        numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return numberFormat.format(number);
    }
}

