/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jtwig.reflection.model.java.JavaMethodArgument;

public class JavaMethod {
    private final Method method;
    private List<JavaMethodArgument> arguments;

    public JavaMethod(Method method) {
        this.method = method;
        this.method.setAccessible(true);
    }

    public List<JavaMethodArgument> arguments() {
        if (this.arguments == null) {
            ArrayList<JavaMethodArgument> result2 = new ArrayList<JavaMethodArgument>();
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result2.add(new JavaMethodArgument(this, i));
            }
            this.arguments = result2;
        }
        return this.arguments;
    }

    public Object invoke(Object bean, Object[] arguments2) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(bean, arguments2);
    }

    public Class type(int position) {
        return this.method.getParameterTypes()[position];
    }

    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public int numberOfArguments() {
        return this.method.getParameterTypes().length;
    }

    public <T extends Annotation> Optional<T> argumentAnnotation(int position, Class<T> type2) {
        Annotation[] annotations2;
        for (Annotation annotation : annotations2 = this.method.getParameterAnnotations()[position]) {
            if (!annotation.annotationType().equals(type2)) continue;
            return Optional.of(type2.cast(annotation));
        }
        return Optional.absent();
    }

    public <T extends Annotation> Optional<T> annotation(Class<T> type2) {
        Annotation[] annotations2;
        for (Annotation annotation : annotations2 = this.method.getAnnotations()) {
            if (!annotation.annotationType().equals(type2)) continue;
            return Optional.of(type2.cast(annotation));
        }
        return Optional.absent();
    }

    public String name() {
        return this.method.getName();
    }

    public Method getNative() {
        return this.method;
    }
}

