/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jtwig.render.context.Context;

public class RenderContext {
    private final Map<Class, Stack<Context<?>>> contexts;

    public static RenderContext create() {
        return new RenderContext(new HashMap());
    }

    public RenderContext(Map<Class, Stack<Context<?>>> contexts) {
        this.contexts = contexts;
    }

    public <T> RenderContext start(Class<T> type2, T context) {
        if (!this.contexts.containsKey(type2)) {
            this.contexts.put(type2, new Stack());
        }
        this.contexts.get(type2).push(Context.create(context));
        return this;
    }

    public <T> T end(Class<T> type2) {
        if (!this.contexts.containsKey(type2)) {
            throw new IllegalStateException(String.format("There is no context for %s", type2));
        }
        Context<?> context = this.contexts.get(type2).pop();
        context.end();
        return type2.cast(context.getItem());
    }

    private <T> Context<T> getCurrentContext(Class<T> type2) {
        if (!this.contexts.containsKey(type2)) {
            throw new IllegalStateException(String.format("There is no context for %s", type2));
        }
        return this.contexts.get(type2).peek();
    }

    public <T> T getCurrent(Class<T> type2) {
        return this.getCurrentContext(type2).getItem();
    }

    public boolean hasCurrent(Class type2) {
        return this.contexts.containsKey(type2) && !this.contexts.get(type2).isEmpty();
    }

    public void onEndCurrent(Class type2, Runnable runnable) {
        this.getCurrentContext(type2).onEnd(runnable);
    }

    public <T> void set(Class<T> type2, T item) {
        this.getCurrentContext(type2).set(item);
    }
}

