/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator.operation.binary.calculators.selection;

import org.jtwig.exceptions.CalculationException;
import org.jtwig.property.selection.SelectionPropertyResolver;
import org.jtwig.property.selection.SelectionRequest;
import org.jtwig.property.selection.SelectionResult;
import org.jtwig.render.expression.calculator.operation.binary.calculators.BinaryOperationCalculator;
import org.jtwig.render.expression.calculator.operation.binary.calculators.selection.SelectionErrorMessageGenerator;
import org.jtwig.util.ErrorMessageFormatter;
import org.jtwig.value.Undefined;

public class SelectionOperationCalculator
implements BinaryOperationCalculator {
    private final SelectionErrorMessageGenerator selectionErrorMessageGenerator;

    public SelectionOperationCalculator(SelectionErrorMessageGenerator selectionErrorMessageGenerator) {
        this.selectionErrorMessageGenerator = selectionErrorMessageGenerator;
    }

    @Override
    public Object calculate(BinaryOperationCalculator.Request request) {
        SelectionPropertyResolver selectionPropertyResolver = request.getEnvironment().getPropertyResolverEnvironment().getSelectionPropertyResolver();
        SelectionResult result2 = selectionPropertyResolver.resolve(new SelectionRequest(request.getRenderContext(), request.getEnvironment(), request.getLeftOperand(), request.getRightOperand()));
        if (result2.getResolvedValue().isPresent()) {
            return result2.getResolvedValue().get().getValue();
        }
        if (request.getEnvironment().getRenderEnvironment().getStrictMode()) {
            throw new CalculationException(ErrorMessageFormatter.errorMessage(request.getPosition(), this.selectionErrorMessageGenerator.explain(request.getLeftOperand(), request.getRightOperand())));
        }
        return Undefined.UNDEFINED;
    }
}

