/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.renderable;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jtwig.renderable.RenderException;
import org.jtwig.renderable.RenderResult;

public class StreamRenderResult
implements RenderResult {
    private final OutputStream outputStream;
    private final Charset charset;

    public StreamRenderResult(OutputStream outputStream, Charset charset) {
        this.outputStream = outputStream;
        this.charset = charset;
    }

    @Override
    public RenderResult append(String content) {
        try {
            this.outputStream.write(content.getBytes(this.charset));
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
        return this;
    }

    @Override
    public RenderResult flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
        return this;
    }

    @Override
    public String content() {
        throw new UnsupportedOperationException("Cannot gather content from output stream");
    }
}

