/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.config;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.Builder;
import org.jtwig.resource.config.ResourceConfiguration;
import org.jtwig.resource.loader.TypedResourceLoader;
import org.jtwig.resource.reference.ResourceReferenceExtractor;
import org.jtwig.resource.resolver.RelativeResourceResolver;
import org.jtwig.util.builder.ListBuilder;

public class ResourceConfigurationBuilder<B extends ResourceConfigurationBuilder>
implements Builder<ResourceConfiguration> {
    private final ListBuilder<B, RelativeResourceResolver> resourceResolvers;
    private final ListBuilder<B, TypedResourceLoader> resourceLoaders;
    private final ListBuilder<B, String> absoluteResourceTypes;
    private ResourceReferenceExtractor resourceReferenceExtractor;
    private Charset defaultInputCharset;

    public ResourceConfigurationBuilder() {
        this.resourceResolvers = new ListBuilder(this.self());
        this.resourceLoaders = new ListBuilder(this.self());
        this.absoluteResourceTypes = new ListBuilder(this.self());
    }

    public ResourceConfigurationBuilder(ResourceConfiguration prototype) {
        this.resourceResolvers = new ListBuilder<B, RelativeResourceResolver>(this.self(), prototype.getRelativeResourceResolvers());
        this.resourceLoaders = new ListBuilder<B, TypedResourceLoader>(this.self(), prototype.getResourceLoaders());
        this.absoluteResourceTypes = new ListBuilder<B, String>(this.self(), prototype.getAbsoluteResourceTypes());
        this.defaultInputCharset = prototype.getDefaultCharset();
        this.resourceReferenceExtractor = prototype.getResourceReferenceExtractor();
    }

    public B withDefaultInputCharset(Charset defaultInputCharset) {
        this.defaultInputCharset = defaultInputCharset;
        return this.self();
    }

    public B withResourceReferenceExtractor(ResourceReferenceExtractor extractor) {
        this.resourceReferenceExtractor = extractor;
        return this.self();
    }

    public ListBuilder<B, RelativeResourceResolver> relativeResourceResolvers() {
        return this.resourceResolvers;
    }

    public ListBuilder<B, TypedResourceLoader> resourceLoaders() {
        return this.resourceLoaders;
    }

    public ListBuilder<B, String> absoluteResourceTypes() {
        return this.absoluteResourceTypes;
    }

    private B self() {
        return (B)this;
    }

    @Override
    public ResourceConfiguration build() {
        return new ResourceConfiguration((Collection<RelativeResourceResolver>)this.resourceResolvers.build(), (Collection<String>)this.absoluteResourceTypes.build(), (List<TypedResourceLoader>)this.resourceLoaders.build(), this.resourceReferenceExtractor, this.defaultInputCharset);
    }
}

