/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.resolver;

import com.google.common.base.Optional;
import java.util.Collection;
import org.jtwig.resource.reference.ResourceReference;
import org.jtwig.resource.resolver.RelativeResourceResolver;
import org.jtwig.resource.resolver.path.RelativeReferenceResolver;

public class ReferenceRelativeResourceResolver
implements RelativeResourceResolver {
    private final Collection<String> pathTypes;
    private final RelativeReferenceResolver relativePathResolver;

    public ReferenceRelativeResourceResolver(Collection<String> pathTypes, RelativeReferenceResolver relativePathResolver) {
        this.pathTypes = pathTypes;
        this.relativePathResolver = relativePathResolver;
    }

    @Override
    public Optional<ResourceReference> resolve(ResourceReference parentReference, ResourceReference newReference) {
        if (this.pathTypes.contains(parentReference.getType())) {
            if (this.relativePathResolver.isRelative(newReference.getPath())) {
                return Optional.of(new ResourceReference(parentReference.getType(), this.relativePathResolver.resolve(parentReference.getPath(), newReference.getPath())));
            }
            return Optional.of(newReference);
        }
        return Optional.absent();
    }
}

