/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.util;

import com.google.common.base.Optional;
import org.jtwig.reflection.model.java.JavaClass;
import org.jtwig.reflection.model.java.JavaClassManager;

public class ClasspathFinder {
    private final ClassLoader classLoader;
    private final JavaClassManager javaClassManager;

    public ClasspathFinder(ClassLoader classLoader, JavaClassManager javaClassManager) {
        this.classLoader = classLoader;
        this.javaClassManager = javaClassManager;
    }

    public boolean exists(String className) {
        return this.load(className).isPresent();
    }

    public Optional<JavaClass> load(String className) {
        try {
            return Optional.of(this.javaClassManager.metadata(Class.forName(className, false, this.classLoader)));
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

