/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.Arrays;
import java.util.Iterator;
import org.parboiled.common.Utils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String escape(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i != cArray.length - 1 && cArray[i] == '\r' && cArray[i + 1] == '\n') continue;
            stringBuilder.append(StringUtils.escape(cArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String escape(char c) {
        switch (c) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '\ufdea': {
                return "DEL_ERROR";
            }
            case '\ufdeb': {
                return "INS_ERROR";
            }
            case '\ufdec': {
                return "RESYNC";
            }
            case '\ufded': {
                return "RESYNC_START";
            }
            case '\ufdee': {
                return "RESYNC_END";
            }
            case '\ufdef': {
                return "RESYNC_EOI";
            }
            case '\ufdd0': {
                return "INDENT";
            }
            case '\ufdd1': {
                return "DEDENT";
            }
            case '\uffff': {
                return "EOI";
            }
        }
        return String.valueOf(c);
    }

    public static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return String.valueOf(cArray);
    }

    public static String join(Iterable iterable, String string) {
        return iterable == null ? null : StringUtils.join(iterable.iterator(), string);
    }

    public static String join(Iterator iterator2, String string) {
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return "";
        }
        Object e = iterator2.next();
        if (!iterator2.hasNext()) {
            return Utils.toString(e);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (e != null) {
            stringBuilder.append(e);
        }
        while (iterator2.hasNext()) {
            Object e2;
            if (string != null) {
                stringBuilder.append(string);
            }
            if ((e2 = iterator2.next()) == null) continue;
            stringBuilder.append(e2);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return objectArray == null ? null : StringUtils.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n, int n2) {
        int n3;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        if ((n3 = n2 - n) <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n3 *= (objectArray[n] == null ? 16 : objectArray[n].toString().length()) + string.length());
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                stringBuilder.append(string);
            }
            if (objectArray[i] == null) continue;
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static boolean startsWith(String string, String string2) {
        return string != null && (string2 == null || string.startsWith(string2));
    }

    public static String substring(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            return "";
        }
        return string.substring(n);
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n, n2);
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(string.length() - n);
    }

    public static String mid(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0 || n > string.length()) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (string.length() <= n + n2) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }
}

