/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImplicitActionsConverter
implements RuleMethodProcessor {
    private final Set<InstructionGraphNode> covered = new HashSet<InstructionGraphNode>();
    private RuleMethod method;

    ImplicitActionsConverter() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.containsImplicitActions();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        this.method = Preconditions.checkArgNotNull(ruleMethod, "method");
        this.covered.clear();
        this.walkNode(ruleMethod.getReturnInstructionNode());
        ruleMethod.setContainsImplicitActions(false);
    }

    private void walkNode(InstructionGraphNode instructionGraphNode) {
        if (this.covered.contains(instructionGraphNode)) {
            return;
        }
        this.covered.add(instructionGraphNode);
        if (this.isImplicitAction(instructionGraphNode)) {
            this.replaceWithActionWrapper(instructionGraphNode);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (!instructionGraphNode.isActionRoot()) {
            for (InstructionGraphNode instructionGraphNode2 : instructionGraphNode.getPredecessors()) {
                this.walkNode(instructionGraphNode2);
            }
        }
    }

    private void replaceWithActionWrapper(InstructionGraphNode instructionGraphNode) {
        MethodInsnNode methodInsnNode = this.createActionWrappingInsn();
        this.method.instructions.set(instructionGraphNode.getInstruction(), methodInsnNode);
        instructionGraphNode.setIsActionRoot();
        instructionGraphNode.setInstruction(methodInsnNode);
    }

    private boolean isImplicitAction(InstructionGraphNode instructionGraphNode) {
        if (!AsmUtils.isBooleanValueOfZ(instructionGraphNode.getInstruction())) {
            return false;
        }
        List<InstructionGraphNode> list2 = this.getDependents(instructionGraphNode);
        if (list2.size() != 1) {
            return false;
        }
        InstructionGraphNode instructionGraphNode2 = list2.get(0);
        return this.isObjectArgumentToRuleCreatingMethodCall(instructionGraphNode, instructionGraphNode2) || this.isStoredIntoObjectArray(instructionGraphNode2);
    }

    private boolean isObjectArgumentToRuleCreatingMethodCall(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode2.getInstruction();
        if (abstractInsnNode.getType() != 5) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        if (!Types.RULE.equals(Type.getReturnType(methodInsnNode.desc))) {
            return false;
        }
        Type[] typeArray = Type.getArgumentTypes(methodInsnNode.desc);
        int n = this.getArgumentIndex(instructionGraphNode2, instructionGraphNode);
        Preconditions.checkState(n < typeArray.length);
        return "java/lang/Object".equals(typeArray[n].getInternalName());
    }

    private boolean isStoredIntoObjectArray(InstructionGraphNode instructionGraphNode) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction();
        if (abstractInsnNode.getOpcode() != 83) {
            return false;
        }
        List<InstructionGraphNode> list2 = this.getDependents(instructionGraphNode);
        Preconditions.checkState(list2.size() == 1);
        AbstractInsnNode abstractInsnNode2 = list2.get(0).getInstruction();
        Preconditions.checkState(abstractInsnNode2.getOpcode() == 189);
        return "java/lang/Object".equals(((TypeInsnNode)abstractInsnNode2).desc);
    }

    private int getArgumentIndex(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        int n;
        for (int i = n = instructionGraphNode.getInstruction().getOpcode() == 184 ? 0 : 1; i < instructionGraphNode.getPredecessors().size(); ++i) {
            InstructionGraphNode instructionGraphNode3 = instructionGraphNode.getPredecessors().get(i);
            if (!instructionGraphNode2.equals(instructionGraphNode3)) continue;
            return i - n;
        }
        throw new IllegalStateException();
    }

    private List<InstructionGraphNode> getDependents(InstructionGraphNode instructionGraphNode) {
        ArrayList<InstructionGraphNode> arrayList = new ArrayList<InstructionGraphNode>();
        for (InstructionGraphNode instructionGraphNode2 : this.method.getGraphNodes()) {
            if (!instructionGraphNode2.getPredecessors().contains(instructionGraphNode)) continue;
            arrayList.add(instructionGraphNode2);
        }
        return arrayList;
    }

    private MethodInsnNode createActionWrappingInsn() {
        return new MethodInsnNode(184, Types.BASE_PARSER.getInternalName(), "ACTION", "(Z)" + Types.ACTION_DESC);
    }
}

