/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScanResult {
    final ScanSpec scanSpec;
    final List<ClasspathElement> classpathOrder;
    private final ClassLoader[] envClassLoaderOrder;
    private final List<File> classpathElementOrderFiles;
    private final List<URL> classpathElementOrderURLs;
    private final NestedJarHandler nestedJarHandler;
    private final Map<File, Long> fileToLastModified;
    final ClassGraphBuilder classGraphBuilder;
    private final List<Throwable> matchProcessorExceptions = new ArrayList<Throwable>();
    final InterruptionChecker interruptionChecker;
    final LogNode log;

    ScanResult(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, ClassLoader[] envClassLoaderOrder, ClassGraphBuilder classGraphBuilder, Map<File, Long> fileToLastModified, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanSpec = scanSpec;
        this.classpathOrder = classpathOrder;
        this.envClassLoaderOrder = envClassLoaderOrder;
        this.classpathElementOrderFiles = new ArrayList<File>();
        this.classpathElementOrderURLs = new ArrayList<URL>();
        for (ClasspathElement classpathElement : classpathOrder) {
            this.classpathElementOrderFiles.add(classpathElement.getClasspathElementFile());
            this.classpathElementOrderURLs.add(classpathElement.getClasspathElementURL());
        }
        this.fileToLastModified = fileToLastModified;
        this.classGraphBuilder = classGraphBuilder;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
        if (classGraphBuilder != null && classGraphBuilder.getClassNameToClassInfo() != null) {
            for (ClassInfo ci : classGraphBuilder.getClassNameToClassInfo().values()) {
                List<MethodInfo> allMethodInfo;
                List<FieldInfo> allFieldInfo = ci.fieldInfo;
                if (allFieldInfo != null) {
                    for (FieldInfo fi : allFieldInfo) {
                        fi.scanResult = this;
                    }
                }
                if ((allMethodInfo = ci.methodInfo) == null) continue;
                for (MethodInfo mi : allMethodInfo) {
                    mi.scanResult = this;
                }
            }
        }
    }

    public ClassLoader[] getClassLoadersForClass(String className) {
        ClassLoader[] classLoaders = this.classGraphBuilder.getClassNameToClassLoaders().get(className);
        if (classLoaders != null) {
            return classLoaders;
        }
        return this.envClassLoaderOrder;
    }

    void addMatchProcessorException(Throwable e) {
        this.matchProcessorExceptions.add(e);
    }

    public List<Throwable> getMatchProcessorExceptions() {
        return this.matchProcessorExceptions;
    }

    public List<File> getUniqueClasspathElements() {
        return this.classpathElementOrderFiles;
    }

    public String getUniqueClasspathElementsAsPathStr() {
        StringBuilder buf = new StringBuilder();
        for (File f : this.getUniqueClasspathElements()) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(f.toString());
        }
        return buf.toString();
    }

    public boolean classpathContentsModifiedSinceScan() {
        if (this.fileToLastModified == null) {
            return true;
        }
        for (Map.Entry<File, Long> ent : this.fileToLastModified.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        long maxLastModifiedTime = 0L;
        if (this.fileToLastModified != null) {
            long currTime = System.currentTimeMillis();
            for (long timestamp : this.fileToLastModified.values()) {
                if (timestamp <= maxLastModifiedTime || timestamp >= currTime) continue;
                maxLastModifiedTime = timestamp;
            }
        }
        return maxLastModifiedTime;
    }

    public Map<String, ClassInfo> getClassNameToClassInfo() {
        return this.classGraphBuilder.getClassNameToClassInfo();
    }

    public List<String> getNamesOfAllClasses() {
        return this.classGraphBuilder.getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.classGraphBuilder.getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        this.scanSpec.checkClassIsNotBlacklisted(superclassName);
        return this.classGraphBuilder.getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(this.scanSpec.getStandardClassName(superclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        this.scanSpec.checkClassIsNotBlacklisted(subclassName);
        return this.classGraphBuilder.getNamesOfSuperclassesOf(subclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.scanSpec.getStandardClassName(subclass));
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        this.scanSpec.checkClassIsNotBlacklisted(fieldTypeName);
        if (!this.scanSpec.enableFieldTypeIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableFieldTypeIndexing() before calling scan() -- field type indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithFieldOfType(Class<?> fieldType) {
        String fieldTypeName = fieldType.getName();
        return this.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        if (!this.scanSpec.enableMethodAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableMethodAnnotationIndexing() before calling scan() -- method annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithMethodAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithMethodAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        if (!this.scanSpec.enableFieldAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableFieldAnnotationIndexing() before calling scan() -- field annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithFieldAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithFieldAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.classGraphBuilder.getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(interfaceName);
        return this.classGraphBuilder.getNamesOfSubinterfacesOf(interfaceName);
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.scanSpec.getInterfaceName(superInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subInterfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(subInterfaceName);
        return this.classGraphBuilder.getNamesOfSuperinterfacesOf(subInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.scanSpec.getInterfaceName(subInterface));
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(interfaceName);
        return this.classGraphBuilder.getNamesOfClassesImplementing(interfaceName);
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.scanSpec.getInterfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames2 = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames2.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames2.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames2);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.scanSpec.getInterfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.classGraphBuilder.getNamesOfAllAnnotationClasses();
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        return this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames2 = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames2.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames2.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames2);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations2) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.scanSpec.getAnnotationNames(annotations2));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames2 = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames2.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames2);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations2) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.scanSpec.getAnnotationNames(annotations2));
    }

    public List<String> getNamesOfAnnotationsOnClass(String className) {
        this.scanSpec.checkClassIsNotBlacklisted(className);
        return this.classGraphBuilder.getNamesOfAnnotationsOnClass(className);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> klass) {
        return this.getNamesOfAnnotationsOnClass(this.scanSpec.getClassOrInterfaceName(klass));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(metaAnnotationName);
        return this.classGraphBuilder.getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.scanSpec.getAnnotationName(metaAnnotation));
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        return this.classGraphBuilder.generateClassGraphDotFile(sizeX, sizeY);
    }

    private Class<?> loadClass(String className, ClassLoader classLoader, LogNode log) throws IllegalArgumentException {
        try {
            return Class.forName(className, this.scanSpec.initializeLoadedClasses, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            if (log != null) {
                log.log("Error while loading class " + className, e);
            }
            throw new IllegalArgumentException("Exception while loading class " + className, e);
        }
    }

    Class<?> loadClass(String className, LogNode log) throws IllegalArgumentException {
        if (this.scanSpec.overrideClasspath != null) {
            throw new IllegalArgumentException("Cannot load classes from custom classpath, defined using .overrideClasspath(), since system classloaders may search a different classpath, and/or may have already loaded and cached a class (which can lead to a class being loaded twice, if a new classloader is defined using the custom classpath). If you want to load classes from a custom classpath at runtime, you need to define your own ClassLoader (e.g. using new URLClassLoader()), and then use .overrideClassLoaders() instead");
        }
        for (ClassLoader classLoader : this.getClassLoadersForClass(className)) {
            Class<?> classRef = this.loadClass(className, classLoader, log);
            if (classRef == null) continue;
            return classRef;
        }
        if (log != null) {
            log.log("No classloader was able to load class " + className);
        }
        throw new IllegalArgumentException("No classloader was able to load class " + className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> classNamesToClassRefs(List<String> classNames2, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            if (classNames2.isEmpty()) {
                List<Class<?>> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList classRefs = new ArrayList();
            for (String className : classNames2) {
                Class<?> classRef = this.classNameToClassRef(className);
                if (classRef == null) continue;
                classRefs.add(classRef);
            }
            List list3 = classRefs.isEmpty() ? Collections.emptyList() : classRefs;
            return list3;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public List<Class<?>> classNamesToClassRefs(List<String> classNames2) throws IllegalArgumentException {
        return this.classNamesToClassRefs(classNames2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class<?> classNameToClassRef(String className, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            if (className == null || className.isEmpty()) {
                if (!ignoreExceptions) {
                    throw new IllegalArgumentException("Class names cannot be null or empty");
                }
                Class<?> clazz = null;
                return clazz;
            }
            if (ignoreExceptions) {
                try {
                    Class<?> clazz = this.loadClass(className, this.log);
                    return clazz;
                }
                catch (IllegalArgumentException e) {
                    Class<?> clazz = null;
                    if (this.log != null) {
                        this.log.flush();
                    }
                    return clazz;
                }
            }
            Class<?> clazz = this.loadClass(className, this.log);
            return clazz;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public Class<?> classNameToClassRef(String className) throws IllegalArgumentException {
        return this.classNameToClassRef(className, false);
    }

    public void freeTempFiles(LogNode log) {
        this.nestedJarHandler.close(log);
    }
}

