/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import name.remal.building.gradle_plugins.MergedCoverageMetricsPluginKt;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import name.remal.building.gradle_plugins.utils.XmlUtilsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0017R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00058\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lname/remal/building/gradle_plugins/CollectMergedCoverageMetricsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "jacocoXmlReportFiles", "", "Ljava/io/File;", "getJacocoXmlReportFiles", "()Ljava/util/List;", "mergedCoverageMetricsPropsFile", "getMergedCoverageMetricsPropsFile", "()Ljava/io/File;", "setMergedCoverageMetricsPropsFile", "(Ljava/io/File;)V", "doCollect", "", "gradle-plugins"})
public class CollectMergedCoverageMetricsTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    @NotNull
    private final List<File> jacocoXmlReportFiles;
    @OutputFile
    @NotNull
    public File mergedCoverageMetricsPropsFile;

    @NotNull
    public List<File> getJacocoXmlReportFiles() {
        return this.jacocoXmlReportFiles;
    }

    @NotNull
    public File getMergedCoverageMetricsPropsFile() {
        File file = this.mergedCoverageMetricsPropsFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mergedCoverageMetricsPropsFile");
        }
        return file;
    }

    public void setMergedCoverageMetricsPropsFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "<set-?>");
        this.mergedCoverageMetricsPropsFile = file;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public void doCollect() {
        Properties properties2;
        long coveredLines = 0L;
        long missedLines = 0L;
        Iterable $receiver$iv = this.getJacocoXmlReportFiles();
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv2;
            File jacocoXmlReportFile = (File)element$iv;
            if (!jacocoXmlReportFile.isFile()) continue;
            this.getLogger().debug("Processing Jacoco XML report file: {}", (Object)jacocoXmlReportFile);
            Object object = MergedCoverageMetricsPluginKt.access$getDocumentBuilder$p().parse(jacocoXmlReportFile).getDocumentElement();
            if (object == null || (object = XmlUtilsKt.getChildElements((Node)object, "counter")) == null) continue;
            Iterable iterable = (Iterable)object;
            for (Object element$iv2 : $receiver$iv2) {
                Long curMissedLines;
                Element counterNode = (Element)element$iv2;
                String string = counterNode.getAttribute("type");
                if (string == null) continue;
                if (!StringsKt.equals(string, "LINE", true)) {
                    continue;
                }
                String string2 = counterNode.getAttribute("covered");
                Long curCoveredLines = string2 != null ? StringsKt.toLongOrNull(string2) : null;
                String string3 = counterNode.getAttribute("missed");
                Long l = curMissedLines = string3 != null ? StringsKt.toLongOrNull(string3) : null;
                if (curCoveredLines != null && curMissedLines != null) {
                    coveredLines += curCoveredLines.longValue();
                    missedLines += curMissedLines.longValue();
                    continue;
                }
                this.getLogger().warn("Unsupported report node: {}", (Object)XmlUtilsKt.asString(counterNode, true));
            }
        }
        Properties $receiver = properties2 = new Properties();
        $receiver.put("covered", String.valueOf(coveredLines));
        $receiver.put("missed", String.valueOf(missedLines));
        CommonKt.store$default($receiver, CommonKt.createParentDirectories(CommonKt.forceCreate(this.getMergedCoverageMetricsPropsFile())), false, 2, null);
    }

    public CollectMergedCoverageMetricsTask() {
        List list2;
        this.setDescription("Collect merged coverage metrics");
        CollectMergedCoverageMetricsTask collectMergedCoverageMetricsTask = this;
        collectMergedCoverageMetricsTask.jacocoXmlReportFiles = list2 = (List)new ArrayList();
    }
}

