/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0017R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lname/remal/building/gradle_plugins/DisplayMergedCoverageMetricsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mergedCoverageMetricsPropsFiles", "", "Ljava/io/File;", "getMergedCoverageMetricsPropsFiles", "()Ljava/util/List;", "doDisplay", "", "gradle-plugins"})
public class DisplayMergedCoverageMetricsTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    @NotNull
    private final List<File> mergedCoverageMetricsPropsFiles;

    @NotNull
    public List<File> getMergedCoverageMetricsPropsFiles() {
        return this.mergedCoverageMetricsPropsFiles;
    }

    @TaskAction
    public void doDisplay() {
        long coveredLines = 0L;
        long missedLines = 0L;
        Iterable $receiver$iv = this.getMergedCoverageMetricsPropsFiles();
        for (Object element$iv : $receiver$iv) {
            Properties properties2;
            File propsFile = (File)element$iv;
            if (!propsFile.exists()) continue;
            this.getLogger().debug("Processing merged coverage metrics properties file: {}", (Object)propsFile);
            Properties $receiver = properties2 = CommonKt.loadProperties(propsFile);
            Object object = $receiver.get("covered");
            coveredLines += object != null && (object = object.toString()) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
            Object object2 = $receiver.get("missed");
            missedLines += object2 != null && (object2 = object2.toString()) != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : 0L;
        }
        long totalLines = coveredLines + missedLines;
        if (0L == totalLines) {
            return;
        }
        this.getLogger().warn("Merged code coverage: {}% ({} of {} lines)", new Object[]{(long)100 * coveredLines / totalLines, coveredLines, totalLines});
    }

    public DisplayMergedCoverageMetricsTask() {
        List list2;
        this.setDescription("Display merged coverage metrics");
        DisplayMergedCoverageMetricsTask displayMergedCoverageMetricsTask = this;
        displayMergedCoverageMetricsTask.mergedCoverageMetricsPropsFiles = list2 = (List)new ArrayList();
    }
}

