/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.artifact;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import name.remal.building.gradle_plugins.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000f"}, d2={"Lname/remal/building/gradle_plugins/artifact/ArtifactsCache;", "", "()V", "cache", "Lcom/google/common/cache/LoadingCache;", "Ljava/io/File;", "Lname/remal/building/gradle_plugins/artifact/Artifact;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger$annotations", "get", "file", "invalidate", "", "gradle-plugins"})
public final class ArtifactsCache {
    private static final Logger logger;
    private static final LoadingCache<File, Artifact> cache;
    public static final ArtifactsCache INSTANCE;

    @JvmStatic
    private static /* synthetic */ void logger$annotations() {
    }

    @NotNull
    public final Artifact get(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Artifact artifact = cache.get(file);
        Intrinsics.checkExpressionValueIsNotNull(artifact, "cache[file]");
        return artifact;
    }

    public final void invalidate(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        logger.debug("Invalidation artifacts cache for {}", (Object)file);
        cache.invalidate(file);
    }

    private ArtifactsCache() {
        INSTANCE = this;
        logger = LoggerFactory.getLogger(ArtifactsCache.class);
        LoadingCache loadingCache = CacheBuilder.newBuilder().softValues().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<File, Artifact>(){

            @NotNull
            public Artifact load(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                return new Artifact(file);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(loadingCache, "CacheBuilder.newBuilder(\u2026Artifact(file)\n        })");
        cache = loadingCache;
    }

    static {
        new ArtifactsCache();
    }
}

