/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.dsl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import name.remal.building.gradle_plugins.dsl.VersionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0002\b\u000f\b\u0086\b\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00019B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nB?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fJ\u0011\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010'\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JH\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010-\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020\u0003J\u0010\u0010/\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020\u0003J\u0010\u00100\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020\u0003J\u0010\u00101\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020\u0003J\b\u00102\u001a\u00020\u0007H\u0016J\u0015\u00103\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0015\u00106\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u00104J\u0015\u00107\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u00104J\u0010\u00108\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001c\u0010\u000eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001d\u0010\u000eR\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"Lname/remal/building/gradle_plugins/dsl/Version;", "", "major", "", "minor", "patch", "suffix", "", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "(ILjava/lang/Integer;Ljava/lang/String;)V", "(ILjava/lang/String;)V", "build", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "getBuild", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "hasBuild", "", "getHasBuild", "()Z", "hasMinor", "getHasMinor", "hasPatch", "getHasPatch", "hasSuffix", "getHasSuffix", "getMajor", "()I", "getMinor", "getPatch", "stringValue", "getSuffix", "()Ljava/lang/String;", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "copy", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Lname/remal/building/gradle_plugins/dsl/Version;", "equals", "", "hashCode", "incrementBuild", "increment", "incrementMajor", "incrementMinor", "incrementPatch", "toString", "withBuild", "(Ljava/lang/Integer;)Lname/remal/building/gradle_plugins/dsl/Version;", "withMajor", "withMinor", "withPatch", "withSuffix", "Companion", "gradle-plugins"})
public final class Version
implements Comparable<Version> {
    private final String stringValue;
    private final int major;
    @Nullable
    private final Integer minor;
    @Nullable
    private final Integer patch;
    @Nullable
    private final Integer build;
    @Nullable
    private final String suffix;
    public static final Companion Companion = new Companion(null);

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        int result2 = Intrinsics.compare(this.major, other.major);
        if (result2 == 0) {
            result2 = VersionKt.access$compareNullsFirst(this.minor, other.minor);
        }
        if (result2 == 0) {
            result2 = VersionKt.access$compareNullsFirst(this.patch, other.patch);
        }
        if (result2 == 0) {
            result2 = VersionKt.access$compareNullsFirst(this.build, other.build);
        }
        if (result2 == 0) {
            result2 = VersionKt.access$compareNullsFirst((Comparable)((Object)this.suffix), (Comparable)((Object)other.suffix));
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return this.stringValue;
    }

    @NotNull
    public final Version withMajor(int major) {
        if (this.major == major) {
            return this;
        }
        return new Version(major, this.minor, this.patch, this.build, this.suffix);
    }

    @NotNull
    public final Version incrementMajor(int increment) {
        if (increment < 0) {
            throw (Throwable)new IllegalArgumentException("increment < 0");
        }
        return new Version(this.major + increment, this.minor, this.patch, this.build, this.suffix);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Version incrementMajor$default(Version version, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return version.incrementMajor(n);
    }

    public final boolean getHasMinor() {
        return this.minor != null;
    }

    @NotNull
    public final Version withMinor(@Nullable Integer minor) {
        if (Intrinsics.areEqual(this.minor, minor)) {
            return this;
        }
        return new Version(this.major, minor, this.patch, this.build, this.suffix);
    }

    @NotNull
    public final Version incrementMinor(int increment) {
        if (increment < 0) {
            throw (Throwable)new IllegalArgumentException("increment < 0");
        }
        return new Version(this.major, VersionKt.access$plus(this.minor, increment), this.patch, this.build, this.suffix);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Version incrementMinor$default(Version version, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return version.incrementMinor(n);
    }

    public final boolean getHasPatch() {
        return this.patch != null;
    }

    @NotNull
    public final Version withPatch(@Nullable Integer patch) {
        if (Intrinsics.areEqual(this.patch, patch)) {
            return this;
        }
        return new Version(this.major, patch != null ? Integer.valueOf(VersionKt.access$plus(this.minor, 0)) : this.minor, patch, this.build, this.suffix);
    }

    @NotNull
    public final Version incrementPatch(int increment) {
        if (increment < 0) {
            throw (Throwable)new IllegalArgumentException("increment < 0");
        }
        return new Version(this.major, VersionKt.access$plus(this.minor, 0), VersionKt.access$plus(this.patch, increment), this.build, this.suffix);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Version incrementPatch$default(Version version, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return version.incrementPatch(n);
    }

    public final boolean getHasBuild() {
        return this.build != null;
    }

    @NotNull
    public final Version withBuild(@Nullable Integer build) {
        if (Intrinsics.areEqual(this.build, build)) {
            return this;
        }
        return new Version(this.major, build != null ? Integer.valueOf(VersionKt.access$plus(this.minor, 0)) : this.minor, build != null ? Integer.valueOf(VersionKt.access$plus(this.patch, 0)) : this.patch, build, this.suffix);
    }

    @NotNull
    public final Version incrementBuild(int increment) {
        if (increment < 0) {
            throw (Throwable)new IllegalArgumentException("increment < 0");
        }
        return new Version(this.major, VersionKt.access$plus(this.minor, 0), VersionKt.access$plus(this.patch, 0), VersionKt.access$plus(this.build, increment), this.suffix);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Version incrementBuild$default(Version version, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return version.incrementBuild(n);
    }

    public final boolean getHasSuffix() {
        return this.suffix != null;
    }

    @NotNull
    public final Version withSuffix(@Nullable String suffix) {
        if (Intrinsics.areEqual(this.suffix, suffix)) {
            return this;
        }
        return new Version(this.major, this.minor, this.patch, this.build, suffix);
    }

    public final int getMajor() {
        return this.major;
    }

    @Nullable
    public final Integer getMinor() {
        return this.minor;
    }

    @Nullable
    public final Integer getPatch() {
        return this.patch;
    }

    @Nullable
    public final Integer getBuild() {
        return this.build;
    }

    @Nullable
    public final String getSuffix() {
        return this.suffix;
    }

    public Version(int major, @Nullable Integer minor, @Nullable Integer patch, @Nullable Integer build, @Nullable String suffix) {
        String string;
        Integer patch2;
        Integer n;
        Integer minor2;
        CharSequence charSequence;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.suffix = suffix;
        if (this.major < 0) {
            throw (Throwable)new IllegalArgumentException("major < 0");
        }
        if (this.minor != null && this.minor < 0) {
            throw (Throwable)new IllegalArgumentException("minor < 0");
        }
        if (this.patch != null && this.patch < 0) {
            throw (Throwable)new IllegalArgumentException("patch < 0");
        }
        if (this.build != null && this.build < 0) {
            throw (Throwable)new IllegalArgumentException("build < 0");
        }
        if (this.suffix != null && (charSequence = (CharSequence)this.suffix).length() == 0) {
            throw (Throwable)new IllegalArgumentException("suffix is empty");
        }
        Version version = this;
        CharSequence $receiver = charSequence = new StringBuilder();
        ((StringBuilder)$receiver).append(this.major);
        Integer n2 = this.minor;
        if (n2 == null) {
            n2 = this.patch != null || this.build != null ? Integer.valueOf(0) : null;
        }
        if ((minor2 = n2) != null) {
            ((StringBuilder)$receiver).append('.').append(minor2);
        }
        if ((n = this.patch) == null) {
            n = this.build != null ? Integer.valueOf(0) : null;
        }
        if ((patch2 = n) != null) {
            ((StringBuilder)$receiver).append('.').append(patch2);
        }
        if (this.build != null) {
            ((StringBuilder)$receiver).append('.').append(this.build);
        }
        if (this.suffix != null) {
            ((StringBuilder)$receiver).append('-').append(this.suffix);
        }
        String string2 = ((StringBuilder)charSequence).toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "StringBuilder().apply(builderAction).toString()");
        version.stringValue = string = string2;
    }

    public /* synthetic */ Version(int n, Integer n2, Integer n3, Integer n4, String string, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = null;
        }
        if ((n5 & 4) != 0) {
            n3 = null;
        }
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        if ((n5 & 0x10) != 0) {
            string = null;
        }
        this(n, n2, n3, n4, string);
    }

    public Version() {
        this(0, null, null, null, null, 31, null);
    }

    public Version(int major, @Nullable Integer minor, @Nullable Integer patch, @Nullable String suffix) {
        this(major, minor, patch, null, suffix);
    }

    public Version(int major, @Nullable Integer minor, @Nullable String suffix) {
        this(major, minor, null, suffix);
    }

    public Version(int major, @Nullable String suffix) {
        this(major, null, suffix);
    }

    public final int component1() {
        return this.major;
    }

    @Nullable
    public final Integer component2() {
        return this.minor;
    }

    @Nullable
    public final Integer component3() {
        return this.patch;
    }

    @Nullable
    public final Integer component4() {
        return this.build;
    }

    @Nullable
    public final String component5() {
        return this.suffix;
    }

    @NotNull
    public final Version copy(int major, @Nullable Integer minor, @Nullable Integer patch, @Nullable Integer build, @Nullable String suffix) {
        return new Version(major, minor, patch, build, suffix);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Version copy$default(Version version, int n, Integer n2, Integer n3, Integer n4, String string, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = version.major;
        }
        if ((n5 & 2) != 0) {
            n2 = version.minor;
        }
        if ((n5 & 4) != 0) {
            n3 = version.patch;
        }
        if ((n5 & 8) != 0) {
            n4 = version.build;
        }
        if ((n5 & 0x10) != 0) {
            string = version.suffix;
        }
        return version.copy(n, n2, n3, n4, string);
    }

    public int hashCode() {
        Integer n = this.minor;
        Integer n2 = this.patch;
        Integer n3 = this.build;
        String string = this.suffix;
        return (((Integer.hashCode(this.major) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (n2 != null ? ((Object)n2).hashCode() : 0)) * 31 + (n3 != null ? ((Object)n3).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Version)) break block3;
                Version version = (Version)object;
                if (!(this.major == version.major) || !Intrinsics.areEqual(this.minor, version.minor) || !Intrinsics.areEqual(this.patch, version.patch) || !Intrinsics.areEqual(this.build, version.build) || !Intrinsics.areEqual(this.suffix, version.suffix)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Version parse(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return Companion.parse(string);
    }

    @JvmStatic
    @Nullable
    public static final Version parseOrNull(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return Companion.parseOrNull(string);
    }

    @JvmStatic
    @NotNull
    public static final Version parseInaccurate(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return Companion.parseInaccurate(string);
    }

    @JvmStatic
    @Nullable
    public static final Version parseInaccurateOrNull(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return Companion.parseInaccurateOrNull(string);
    }

    @JvmStatic
    @NotNull
    public static final Version ofLocalDateTime(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkParameterIsNotNull(dateTime, "dateTime");
        return Companion.ofLocalDateTime(dateTime);
    }

    @JvmStatic
    @NotNull
    public static final Version ofTimestamp(long timestamp) {
        return Companion.ofTimestamp(timestamp);
    }

    @JvmStatic
    @NotNull
    public static final Version ofDate(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull(date, "date");
        return Companion.ofDate(date);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0013"}, d2={"Lname/remal/building/gradle_plugins/dsl/Version$Companion;", "", "()V", "ofDate", "Lname/remal/building/gradle_plugins/dsl/Version;", "date", "Ljava/util/Date;", "ofLocalDateTime", "dateTime", "Ljava/time/LocalDateTime;", "ofTimestamp", "timestamp", "", "parse", "string", "", "parseInaccurate", "parseInaccurateOrNull", "parseOrNull", "gradle-plugins"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Version parse(@NotNull String string) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Version version;
            Intrinsics.checkParameterIsNotNull(string, "string");
            Matcher matcher = VersionKt.access$getPATTERN$p().matcher(string);
            if (!matcher.matches()) {
                throw (Throwable)new IllegalArgumentException("version string '" + string + "' isn't matched /" + VersionKt.access$getPATTERN$p() + '/');
            }
            String string2 = matcher.group("major");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Version version2 = version;
            Version version3 = version;
            String p1 = string3;
            int n6 = Integer.parseInt(p1);
            Version version4 = version3;
            Version version5 = version2;
            int n7 = n6;
            String string4 = matcher.group("minor");
            if (string4 != null) {
                string3 = string4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                n5 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
            } else {
                n4 = null;
            }
            String string5 = matcher.group("patch");
            if (string5 != null) {
                string3 = string5;
                n5 = n4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                n3 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
                n2 = n3;
            } else {
                n2 = null;
            }
            String string6 = matcher.group("build");
            if (string6 != null) {
                string3 = string6;
                n3 = n2;
                n5 = n4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                Integer n8 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
                n2 = n3;
                n = n8;
            } else {
                n = null;
            }
            version5(n7, n4, n2, n, matcher.group("suffix"));
            return version4;
        }

        @JvmStatic
        @Nullable
        public final Version parseOrNull(@NotNull String string) {
            Version version;
            Intrinsics.checkParameterIsNotNull(string, "string");
            try {
                version = this.parse(string);
            }
            catch (Exception ignored) {
                version = null;
            }
            return version;
        }

        @JvmStatic
        @NotNull
        public final Version parseInaccurate(@NotNull String string) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            Integer n5;
            Version version;
            Intrinsics.checkParameterIsNotNull(string, "string");
            Matcher matcher = VersionKt.access$getINACCURATE_PATTERN$p().matcher(string);
            if (!matcher.matches()) {
                throw (Throwable)new IllegalArgumentException("version string '" + string + "' isn't matched /" + VersionKt.access$getINACCURATE_PATTERN$p() + '/');
            }
            String string2 = matcher.group("major");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Version version2 = version;
            Version version3 = version;
            String p1 = string3;
            int n6 = Integer.parseInt(p1);
            Version version4 = version3;
            Version version5 = version2;
            int n7 = n6;
            String string4 = matcher.group("minor");
            if (string4 != null) {
                string3 = string4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                n5 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
            } else {
                n4 = null;
            }
            String string5 = matcher.group("patch");
            if (string5 != null) {
                string3 = string5;
                n5 = n4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                n3 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
                n2 = n3;
            } else {
                n2 = null;
            }
            String string6 = matcher.group("build");
            if (string6 != null) {
                string3 = string6;
                n3 = n2;
                n5 = n4;
                n6 = n7;
                version2 = version5;
                version3 = version4;
                p1 = string3;
                Integer n8 = Integer.parseInt(p1);
                version4 = version3;
                version5 = version2;
                n7 = n6;
                n4 = n5;
                n2 = n3;
                n = n8;
            } else {
                n = null;
            }
            version5(n7, n4, n2, n, matcher.group("suffix"));
            return version4;
        }

        @JvmStatic
        @Nullable
        public final Version parseInaccurateOrNull(@NotNull String string) {
            Version version;
            Intrinsics.checkParameterIsNotNull(string, "string");
            try {
                version = this.parseInaccurate(string);
            }
            catch (Exception ignored) {
                version = null;
            }
            return version;
        }

        @JvmStatic
        @NotNull
        public final Version ofLocalDateTime(@NotNull LocalDateTime dateTime) {
            Version version;
            ZonedDateTime zonedDateTime;
            Intrinsics.checkParameterIsNotNull(dateTime, "dateTime");
            ZonedDateTime it = zonedDateTime = dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("UTC"));
            String string = "%02d%02d%02d";
            Object[] objectArray = new Object[]{it.get(ChronoField.HOUR_OF_DAY), it.get(ChronoField.MINUTE_OF_HOUR), it.get(ChronoField.SECOND_OF_MINUTE)};
            Integer n = null;
            Integer n2 = it.get(ChronoField.DAY_OF_MONTH);
            Integer n3 = it.get(ChronoField.MONTH_OF_YEAR);
            int n4 = it.get(ChronoField.YEAR);
            Version version2 = version;
            Version version3 = version;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(this, *args)");
            String string3 = string2;
            version2(n4, n3, n2, n, string3);
            return version3;
        }

        @JvmStatic
        @NotNull
        public final Version ofTimestamp(long timestamp) {
            LocalDateTime localDateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
            Intrinsics.checkExpressionValueIsNotNull(localDateTime, "Instant.ofEpochMilli(tim\u2026ault()).toLocalDateTime()");
            return this.ofLocalDateTime(localDateTime);
        }

        @JvmStatic
        @NotNull
        public final Version ofDate(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull(date, "date");
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            Intrinsics.checkExpressionValueIsNotNull(localDateTime, "LocalDateTime.ofInstant(\u2026, ZoneId.systemDefault())");
            return this.ofLocalDateTime(localDateTime);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

