/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.generate_sources;

import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J/\u0010\u0017\u001a\u00020\u0012*\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00032\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u001a\u00a2\u0006\u0002\b\u001bH\u0004J\u0018\u0010\u001c\u001a\u00020\u0012*\u00020\u00162\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0003H\u0014J\f\u0010 \u001a\u00020\u0012*\u00020\u0016H\u0014J \u0010!\u001a\u00020\u0012*\u00020\u00162\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u001c\u0010!\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0014J'\u0010#\u001a\u00020\u0012*\u00020\u00162\u0014\b\u0002\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030%\"\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\n\u00a8\u0006'"}, d2={"Lname/remal/building/gradle_plugins/generate_sources/BaseSourceGenerator;", "", "packageName", "", "fileName", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "indentSize", "", "getIndentSize", "()I", "getPackageName", "setPackageName", "accept", "", "project", "Lorg/gradle/api/Project;", "writer", "Ljava/io/Writer;", "writeBlock", "expression", "blockWriterHandler", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeImport", "clazz", "Ljava/lang/Class;", "canonicalClassName", "writePackage", "writeStaticImport", "member", "writeSuppressWarnings", "warnings", "", "(Ljava/io/Writer;[Ljava/lang/String;)V", "gradle-plugins"})
public abstract class BaseSourceGenerator {
    @NotNull
    public String packageName;
    @NotNull
    public String fileName;
    private final int indentSize = 4;

    public abstract void accept(@NotNull Project var1, @NotNull Writer var2);

    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("packageName");
        }
        return string;
    }

    public final void setPackageName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final String getFileName() {
        String string = this.fileName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fileName");
        }
        return string;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.fileName = string;
    }

    protected void writePackage(@NotNull Writer $receiver) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("packageName");
        }
        if ((charSequence = (CharSequence)string).length() > 0) {
            Writer writer = $receiver.append("package ");
            String string2 = this.packageName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("packageName");
            }
            writer.append(string2).append(";\n");
        }
    }

    protected void writeImport(@NotNull Writer $receiver, @NotNull String canonicalClassName) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(canonicalClassName, "canonicalClassName");
        $receiver.append("import ").append(canonicalClassName).append(";\n");
    }

    public void writeImport(@NotNull Writer $receiver, @NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        String string = clazz.getCanonicalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "clazz.canonicalName");
        this.writeImport($receiver, string);
    }

    protected void writeStaticImport(@NotNull Writer $receiver, @NotNull String canonicalClassName, @NotNull String member) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(canonicalClassName, "canonicalClassName");
        Intrinsics.checkParameterIsNotNull(member, "member");
        $receiver.append("import static ").append(canonicalClassName).append('.').append(member).append(";\n");
    }

    public void writeStaticImport(@NotNull Writer $receiver, @NotNull Class<?> clazz, @NotNull String member) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        Intrinsics.checkParameterIsNotNull(member, "member");
        String string = clazz.getCanonicalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "clazz.canonicalName");
        this.writeStaticImport($receiver, string, member);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeSuppressWarnings(@NotNull Writer $receiver, String ... warnings) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(warnings, "warnings");
        $receiver.append("@SuppressWarnings({");
        Object[] $receiver$iv = warnings;
        int index$iv = 0;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            void warning;
            Object item$iv = $receiver$iv[i];
            int n = index$iv++;
            String string = (String)item$iv;
            int index = n;
            if (1 < index) {
                $receiver.append(", ");
            }
            $receiver.append('\"').append(CommonKt.escapeJava((String)warning)).append('\"');
        }
        $receiver.append("})\n");
    }

    public static /* bridge */ /* synthetic */ void writeSuppressWarnings$default(BaseSourceGenerator baseSourceGenerator, Writer writer, String[] stringArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeSuppressWarnings");
        }
        if ((n & 1) != 0) {
            Object[] elements$iv = new String[]{"all"};
            stringArray = (String[])elements$iv;
        }
        baseSourceGenerator.writeSuppressWarnings(writer, stringArray);
    }

    protected int getIndentSize() {
        return this.indentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBlock(@NotNull Writer $receiver, @NotNull String expression, @NotNull Function1<? super Writer, Unit> blockWriterHandler) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(blockWriterHandler, "blockWriterHandler");
        Object object = expression;
        if (object.length() > 0) {
            $receiver.append(expression);
            $receiver.append(' ');
        }
        $receiver.append('{');
        object = new StringWriter();
        boolean bl = false;
        try {
            StringWriter blockWriter = (StringWriter)object;
            blockWriterHandler.invoke(blockWriter);
            CharSequence charSequence = StringsKt.replace$default(blockWriter.toString(), "\r", "", false, 4, null);
            String it = charSequence;
            String string = StringsKt.endsWith$default((CharSequence)it, '\n', false, 2, null) ? StringsKt.substringBeforeLast$default(it, '\n', null, 2, null) : it;
            String content = string;
            charSequence = content;
            if (charSequence.length() > 0) {
                $receiver.append('\n');
                String indent = StringsKt.repeat(" ", this.getIndentSize());
                Iterable $receiver$iv = StringsKt.split$default((CharSequence)content, new char[]{'\n'}, false, 0, 6, null);
                for (Object element$iv : $receiver$iv) {
                    String it2 = (String)element$iv;
                    $receiver.append(indent).append(it2).append('\n');
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    object.close();
                }
                throw throwable;
            }
        }
        object.close();
        $receiver.append('}');
    }

    public static /* bridge */ /* synthetic */ void writeBlock$default(BaseSourceGenerator baseSourceGenerator, Writer writer, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeBlock");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        baseSourceGenerator.writeBlock(writer, string, function1);
    }

    public BaseSourceGenerator() {
        this.indentSize = 4;
    }

    public BaseSourceGenerator(@NotNull String packageName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        this();
        this.packageName = packageName;
        this.fileName = fileName;
    }
}

