/*
 * Decompiled with CFR 0.152.
 */
package name.remal.building.gradle_plugins.packed_dependencies;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import name.remal.building.gradle_plugins.dsl.CommonKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0010\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lname/remal/building/gradle_plugins/packed_dependencies/PackedDependencyInfo;", "", "project", "Lorg/gradle/api/Project;", "resolvedArtifact", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/ResolvedArtifact;)V", "resourceName", "", "artifactFile", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getArtifactFile", "()Ljava/io/File;", "getResourceName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-plugins"})
public final class PackedDependencyInfo {
    @NotNull
    private final String resourceName;
    @NotNull
    private final File artifactFile;

    public int hashCode() {
        return this.resourceName.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PackedDependencyInfo)) {
            return false;
        }
        return Intrinsics.areEqual(this.resourceName, ((PackedDependencyInfo)other).resourceName);
    }

    @NotNull
    public final String getResourceName() {
        return this.resourceName;
    }

    @NotNull
    public final File getArtifactFile() {
        return this.artifactFile;
    }

    public PackedDependencyInfo(@NotNull String resourceName, @NotNull File artifactFile) {
        Intrinsics.checkParameterIsNotNull(resourceName, "resourceName");
        Intrinsics.checkParameterIsNotNull(artifactFile, "artifactFile");
        this.resourceName = resourceName;
        this.artifactFile = artifactFile;
    }

    public PackedDependencyInfo(@NotNull Project project, @NotNull ResolvedArtifact resolvedArtifact) {
        String string;
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(resolvedArtifact, "resolvedArtifact");
        ResolvedArtifact resolvedArtifact2 = resolvedArtifact;
        PackedDependencyInfo packedDependencyInfo = this;
        ResolvedArtifact it = resolvedArtifact2;
        ComponentIdentifier id = it.getId().getComponentIdentifier();
        if (id instanceof ModuleComponentIdentifier) {
            string = "META-INF/packed-deps/" + CommonKt.decodeURIComponent(((ModuleComponentIdentifier)id).getGroup().toString()) + '.' + CommonKt.decodeURIComponent(((ModuleComponentIdentifier)id).getModule()) + '.' + it.getExtension();
        } else if (id instanceof ProjectComponentIdentifier) {
            String projectPath = ((ProjectComponentIdentifier)id).getProjectPath();
            Project dependencyProject = project.getRootProject().evaluationDependsOn(projectPath);
            string = "META-INF/packed-deps/" + CommonKt.decodeURIComponent(dependencyProject.getGroup().toString()) + '.' + CommonKt.decodeURIComponent(dependencyProject.getName()) + '.' + it.getExtension();
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported artifact: " + it);
        }
        String string2 = string;
        File file = resolvedArtifact.getFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "resolvedArtifact.file");
        packedDependencyInfo(string2, file);
    }

    @NotNull
    public final String component1() {
        return this.resourceName;
    }

    @NotNull
    public final File component2() {
        return this.artifactFile;
    }

    @NotNull
    public final PackedDependencyInfo copy(@NotNull String resourceName, @NotNull File artifactFile) {
        Intrinsics.checkParameterIsNotNull(resourceName, "resourceName");
        Intrinsics.checkParameterIsNotNull(artifactFile, "artifactFile");
        return new PackedDependencyInfo(resourceName, artifactFile);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PackedDependencyInfo copy$default(PackedDependencyInfo packedDependencyInfo, String string, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = packedDependencyInfo.resourceName;
        }
        if ((n & 2) != 0) {
            file = packedDependencyInfo.artifactFile;
        }
        return packedDependencyInfo.copy(string, file);
    }

    public String toString() {
        return "PackedDependencyInfo(resourceName=" + this.resourceName + ", artifactFile=" + this.artifactFile + ")";
    }
}

