/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.URIish;

class FetchHeadRecord {
    ObjectId newValue;
    boolean notForMerge;
    String sourceName;
    URIish sourceURI;

    FetchHeadRecord() {
    }

    void write(Writer pw) throws IOException {
        String name;
        String type2;
        if (this.sourceName.startsWith("refs/heads/")) {
            type2 = "branch";
            name = this.sourceName.substring("refs/heads/".length());
        } else if (this.sourceName.startsWith("refs/tags/")) {
            type2 = "tag";
            name = this.sourceName.substring("refs/tags/".length());
        } else if (this.sourceName.startsWith("refs/remotes/")) {
            type2 = "remote branch";
            name = this.sourceName.substring("refs/remotes/".length());
        } else {
            type2 = "";
            name = this.sourceName;
        }
        pw.write(this.newValue.name());
        pw.write(9);
        if (this.notForMerge) {
            pw.write("not-for-merge");
        }
        pw.write(9);
        pw.write(type2);
        pw.write(" '");
        pw.write(name);
        pw.write("' of ");
        pw.write(this.sourceURI.toString());
        pw.write("\n");
    }
}

