/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions;

import java.util.List;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.functions.FunctionArguments;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.position.Position;
import org.jtwig.render.RenderRequest;
import org.jtwig.util.ErrorMessageFormatter;

public class FunctionRequest
extends RenderRequest {
    private final Position position;
    private final String functionName;
    private final FunctionArguments functionArguments;

    public FunctionRequest(RenderRequest request, Position position, String functionName, FunctionArguments functionArguments) {
        super(request.getRenderContext(), request.getEnvironment());
        this.position = position;
        this.functionName = functionName;
        this.functionArguments = functionArguments;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getNumberOfArguments() {
        return this.functionArguments.size();
    }

    public List<Object> getArguments() {
        return this.functionArguments.getValues();
    }

    public List<Expression> getExpressionArguments() {
        return this.functionArguments.getExpressions();
    }

    public FunctionRequest minimumNumberOfArguments(int number) {
        if (this.functionArguments.size() < number) {
            throw this.exception(String.format("Expected at least %d arguments", number));
        }
        return this;
    }

    public FunctionRequest maximumNumberOfArguments(int number) {
        if (this.functionArguments.size() > number) {
            throw this.exception(String.format("Expected at most %d arguments", number));
        }
        return this;
    }

    public CalculationException exception(String message) {
        return new CalculationException(ErrorMessageFormatter.errorMessage(this.position, String.format("Function %s error: %s", this.functionName, message)));
    }

    public CalculationException exception(String message, Throwable e) {
        return new CalculationException(ErrorMessageFormatter.errorMessage(this.position, String.format("Function %s error: %s", this.functionName, message)), e);
    }

    public Object get(int index) {
        return this.functionArguments.getValue(index);
    }

    public Expression getExpression(int index) {
        return this.functionArguments.getExpression(index);
    }

    public Object[] getRemainingArguments(int start) {
        return this.functionArguments.getRemainingArguments(start);
    }
}

