/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.strategy.method.argument.group;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jtwig.property.strategy.method.argument.group.ArgumentGroup;
import org.jtwig.property.strategy.method.argument.group.SingleArgumentGroup;
import org.jtwig.property.strategy.method.argument.group.VarArgumentGroup;
import org.jtwig.reflection.model.java.JavaMethod;
import org.jtwig.reflection.model.java.JavaMethodArgument;

public class GroupingArgumentsService {
    public Optional<List<ArgumentGroup>> groupArguments(JavaMethod method, Object[] arguments2) {
        if (method.isVarArgs()) {
            if (arguments2.length >= method.numberOfArguments() - 1) {
                return Optional.of(this.groupVarArgs(method.arguments(), arguments2));
            }
        } else if (arguments2.length == method.numberOfArguments()) {
            return Optional.of(this.groupSimpleArgs(method.arguments(), arguments2, arguments2.length));
        }
        return Optional.absent();
    }

    private List<ArgumentGroup> groupSimpleArgs(List<JavaMethodArgument> javaMethodArguments, Object[] arguments2, int max) {
        ArrayList<ArgumentGroup> groups2 = new ArrayList<ArgumentGroup>();
        for (int i = 0; i < max; ++i) {
            JavaMethodArgument javaMethodArgument = javaMethodArguments.get(i);
            groups2.add(new SingleArgumentGroup(javaMethodArgument, arguments2[i]));
        }
        return groups2;
    }

    private List<ArgumentGroup> groupVarArgs(List<JavaMethodArgument> argumentList, Object[] arguments2) {
        int max = argumentList.size() - 1;
        List<ArgumentGroup> result2 = this.groupSimpleArgs(argumentList, arguments2, max);
        result2.add(new VarArgumentGroup(argumentList.get(max), Arrays.asList(arguments2).subList(max, arguments2.length)));
        return result2;
    }
}

