/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.jtwig.reflection.model.java.JavaClass;
import org.jtwig.reflection.model.java.JavaConstant;
import org.jtwig.reflection.model.java.JavaField;
import org.jtwig.reflection.model.java.JavaMethod;
import org.jtwig.reflection.model.java.JavaMethods;
import org.jtwig.reflection.model.java.MethodSignature;

public class JavaClassFactory {
    public JavaClass create(Class type2) {
        HashMap<String, JavaConstant> constants = new HashMap<String, JavaConstant>();
        HashMap<String, JavaField> fields2 = new HashMap<String, JavaField>();
        HashMap<String, Map<MethodSignature, JavaMethod>> methodsByName = new HashMap<String, Map<MethodSignature, JavaMethod>>();
        HashMap<String, JavaMethods> javaMethods = new HashMap<String, JavaMethods>();
        this.extractFields(type2, constants, fields2);
        this.extractMethods(type2, methodsByName);
        for (Map.Entry entry : methodsByName.entrySet()) {
            javaMethods.put((String)entry.getKey(), new JavaMethods((Map)entry.getValue()));
        }
        JavaClass result2 = new JavaClass(type2, constants, fields2, javaMethods);
        if (type2.getSuperclass() != Object.class) {
            JavaClass javaClass = this.create(type2.getSuperclass());
            result2.merge(javaClass);
        }
        return result2;
    }

    private void extractMethods(Class type2, Map<String, Map<MethodSignature, JavaMethod>> methodsByName) {
        for (Method method : type2.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            JavaMethod javaMethod = new JavaMethod(method);
            if (!methodsByName.containsKey(method.getName())) {
                methodsByName.put(method.getName(), new HashMap());
            }
            methodsByName.get(method.getName()).put(new MethodSignature(method.getParameterTypes()), javaMethod);
        }
    }

    private void extractFields(Class type2, Map<String, JavaConstant> constants, Map<String, JavaField> fields2) {
        for (Field field : type2.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) {
                constants.put(field.getName(), new JavaConstant(field));
                continue;
            }
            fields2.put(field.getName(), new JavaField(field));
        }
    }
}

