/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;

public final class Lists2 {
    private Lists2() {
    }

    public static <O, I> List<O> transform(List<I> inputList, Function<I, O> transformation) {
        ArrayList<O> result2 = new ArrayList<O>();
        for (I input : inputList) {
            result2.add(transformation.apply(input));
        }
        return result2;
    }

    public static <T> List<T> filter(List<T> inputList, Predicate<T> filter) {
        ArrayList<T> result2 = new ArrayList<T>();
        for (T input : inputList) {
            if (!filter.apply(input)) continue;
            result2.add(input);
        }
        return result2;
    }

    public static <T> Optional<T> find(List<T> list2, Predicate<T> predicate) {
        for (T element : list2) {
            if (element == null || !predicate.apply(element)) continue;
            return Optional.of(element);
        }
        return Optional.absent();
    }

    public static <T> int positionOf(List<T> inputParameters, Predicate<T> predicate) {
        for (int i = 0; i < inputParameters.size(); ++i) {
            if (!predicate.apply(inputParameters.get(i))) continue;
            return i;
        }
        return -1;
    }
}

