/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.context;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Context<T> {
    private final AtomicReference<T> item;
    private final List<Runnable> endTasks;

    public static <T> Context<T> create(T item) {
        return new Context<T>(item, new ArrayList<Runnable>());
    }

    private Context(T item, List<Runnable> endTasks) {
        this.item = new AtomicReference<T>(item);
        this.endTasks = endTasks;
    }

    public T getItem() {
        return this.item.get();
    }

    public void onEnd(Runnable run2) {
        this.endTasks.add(run2);
    }

    public void end() {
        for (Runnable task2 : this.endTasks) {
            task2.run();
        }
    }

    public void set(T item) {
        this.item.set(item);
    }
}

