/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression;

import com.google.common.base.Optional;
import java.util.Map;
import org.jtwig.model.expression.Expression;
import org.jtwig.render.expression.calculator.ExpressionCalculator;
import org.jtwig.util.ErrorMessageFormatter;

public class ExpressionCalculatorSelector {
    private final Map<Class<? extends Expression>, ExpressionCalculator> expressionCalculatorMap;

    public ExpressionCalculatorSelector(Map<Class<? extends Expression>, ExpressionCalculator> expressionCalculatorMap) {
        this.expressionCalculatorMap = expressionCalculatorMap;
    }

    public ExpressionCalculator calculatorFor(Expression expression) {
        Optional<ExpressionCalculator> optional = Optional.fromNullable(this.expressionCalculatorMap.get(expression.getClass()));
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new IllegalArgumentException(ErrorMessageFormatter.errorMessage(expression.getPosition(), String.format("No calculator for expression of type %s", expression.getClass())));
    }
}

