/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.buffers.MutableInputBuffer;
import org.parboiled.common.ImmutableLinkedList;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchervisitors.DefaultMatcherVisitor;
import org.parboiled.matchervisitors.FollowMatchersVisitor;
import org.parboiled.matchervisitors.GetStarterCharVisitor;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.matchervisitors.IsStarterCharVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.parserunners.ErrorLocatingParseRunner;
import org.parboiled.parserunners.ErrorReportingParseRunner;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveringParseRunner<V>
extends AbstractParseRunner<V> {
    private final long timeout;
    private long startTimeStamp;
    private int errorIndex;
    private InvalidInputError currentError;
    private MutableInputBuffer buffer;
    private ParsingResult<V> lastParsingResult;
    private Matcher rootMatcherWithoutPTB;

    @Deprecated
    public static <V> ParsingResult<V> run(Rule rule, String string) {
        Preconditions.checkArgNotNull(rule, "rule");
        Preconditions.checkArgNotNull(string, "input");
        return new RecoveringParseRunner<V>(rule).run(string);
    }

    public RecoveringParseRunner(Rule rule) {
        this(rule, Long.MAX_VALUE);
    }

    public RecoveringParseRunner(Rule rule, long l) {
        super(rule);
        this.timeout = l;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.startTimeStamp = System.currentTimeMillis();
        this.resetValueStack();
        ParseRunner parseRunner = new BasicParseRunner(this.getRootMatcher()).withParseErrors(this.getParseErrors()).withValueStack(this.getValueStack());
        this.lastParsingResult = parseRunner.run(inputBuffer);
        if (!this.lastParsingResult.matched) {
            this.rootMatcherWithoutPTB = (Matcher)this.getRootMatcher().suppressNode();
            this.performLocatingRun(inputBuffer);
            Preconditions.checkState(this.errorIndex >= 0);
            this.buffer = new MutableInputBuffer(inputBuffer);
            this.performReportingRun();
            while (!this.fixError(this.errorIndex)) {
                this.performReportingRun();
            }
            if (!this.getRootMatcher().isNodeSuppressed()) {
                this.performFinalRun();
                Preconditions.checkState(this.lastParsingResult.matched);
            }
        }
        return this.lastParsingResult;
    }

    private boolean performLocatingRun(InputBuffer inputBuffer) {
        this.resetValueStack();
        ParseRunner parseRunner = new ErrorLocatingParseRunner(this.rootMatcherWithoutPTB, this.getInnerHandler()).withParseErrors(this.getParseErrors()).withValueStack(this.getValueStack());
        this.lastParsingResult = parseRunner.run(inputBuffer);
        this.errorIndex = this.lastParsingResult.matched ? -1 : this.getParseErrors().remove(this.getParseErrors().size() - 1).getStartIndex();
        return this.lastParsingResult.matched;
    }

    private void performReportingRun() {
        this.resetValueStack();
        ParseRunner parseRunner = new ErrorReportingParseRunner(this.rootMatcherWithoutPTB, this.errorIndex, this.getInnerHandler()).withParseErrors(this.getParseErrors()).withValueStack(this.getValueStack());
        ParsingResult parsingResult = parseRunner.run(this.buffer);
        Preconditions.checkState(!parsingResult.matched);
        this.currentError = (InvalidInputError)this.getParseErrors().get(this.getParseErrors().size() - 1);
    }

    private void performFinalRun() {
        this.resetValueStack();
        Handler handler = new Handler();
        MatcherContext matcherContext = this.createRootContext(this.buffer, handler, false);
        boolean bl = handler.match(matcherContext);
        this.lastParsingResult = this.createParsingResult(bl, matcherContext);
    }

    private MatchHandler getInnerHandler() {
        return this.errorIndex >= 0 ? new Handler() : null;
    }

    private boolean fixError(int n) {
        if (this.tryFixBySingleCharDeletion(n)) {
            return true;
        }
        int n2 = this.errorIndex;
        Character c = this.findBestSingleCharInsertion(n);
        if (c == null) {
            return true;
        }
        int n3 = this.errorIndex;
        Character c2 = this.findBestSingleCharReplacement(n);
        if (c2 == null) {
            return true;
        }
        int n4 = this.errorIndex;
        int n5 = Math.max(Math.max(n2, n3), n4);
        if (n5 > n) {
            if (n5 == n2) {
                this.buffer.insertChar(n, '\ufdea');
                this.errorIndex = n2 + 1;
                this.currentError.shiftIndexDeltaBy(1);
            } else if (n5 == n3) {
                this.buffer.insertChar(n, c.charValue());
                this.buffer.insertChar(n, '\ufdeb');
                this.errorIndex = n3 + 2;
                this.currentError.shiftIndexDeltaBy(2);
            } else {
                this.buffer.insertChar(n + 1, c2.charValue());
                this.buffer.insertChar(n + 1, '\ufdeb');
                this.buffer.insertChar(n, '\ufdea');
                this.errorIndex = n4 + 5;
                this.currentError.shiftIndexDeltaBy(1);
            }
        } else {
            if (this.buffer.charAt(n) == '\uffff') {
                this.buffer.insertChar(n, '\ufdef');
                this.currentError.shiftIndexDeltaBy(1);
                return true;
            }
            this.buffer.insertChar(n, '\ufdec');
            this.currentError.shiftIndexDeltaBy(1);
            this.performLocatingRun(this.buffer);
        }
        return this.errorIndex == -1;
    }

    private boolean tryFixBySingleCharDeletion(int n) {
        this.buffer.insertChar(n, '\ufdea');
        boolean bl = this.performLocatingRun(this.buffer);
        if (bl) {
            this.currentError.shiftIndexDeltaBy(1);
        } else {
            this.buffer.undoCharInsertion(n);
            this.errorIndex = Math.max(this.errorIndex - 1, 0);
        }
        return bl;
    }

    private Character findBestSingleCharInsertion(int n) {
        GetStarterCharVisitor getStarterCharVisitor = new GetStarterCharVisitor();
        int n2 = -1;
        Character c = Character.valueOf('\u0000');
        for (MatcherPath matcherPath : this.currentError.getFailedMatchers()) {
            Character c2 = matcherPath.element.matcher.accept(getStarterCharVisitor);
            Preconditions.checkState(c2 != null);
            if (c2.charValue() == '\uffff') continue;
            this.buffer.insertChar(n, c2.charValue());
            this.buffer.insertChar(n, '\ufdeb');
            if (this.performLocatingRun(this.buffer)) {
                this.currentError.shiftIndexDeltaBy(2);
                return null;
            }
            this.buffer.undoCharInsertion(n);
            this.buffer.undoCharInsertion(n);
            this.errorIndex = Math.max(this.errorIndex - 2, 0);
            if (n2 >= this.errorIndex) continue;
            n2 = this.errorIndex;
            c = c2;
        }
        this.errorIndex = n2;
        return c;
    }

    private Character findBestSingleCharReplacement(int n) {
        this.buffer.insertChar(n, '\ufdea');
        Character c = this.findBestSingleCharInsertion(n + 2);
        if (c == null) {
            this.currentError.shiftIndexDeltaBy(-1);
        } else {
            this.buffer.undoCharInsertion(n);
            this.errorIndex = Math.max(this.errorIndex - 3, 0);
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectResyncActionsVisitor
    extends DefaultMatcherVisitor<List<ActionMatcher>> {
        private ImmutableLinkedList<SequenceMatcher> path = ImmutableLinkedList.nil();

        private CollectResyncActionsVisitor() {
        }

        @Override
        public List<ActionMatcher> visit(ActionMatcher actionMatcher) {
            return ImmutableList.of(actionMatcher);
        }

        @Override
        public List<ActionMatcher> visit(FirstOfMatcher firstOfMatcher) {
            for (Matcher matcher : firstOfMatcher.getChildren()) {
                List<ActionMatcher> list2 = matcher.accept(this);
                if (list2 == null) continue;
                return list2;
            }
            return null;
        }

        @Override
        public List<ActionMatcher> visit(OneOrMoreMatcher oneOrMoreMatcher) {
            return oneOrMoreMatcher.subMatcher.accept(this);
        }

        @Override
        public List<ActionMatcher> visit(SequenceMatcher sequenceMatcher) {
            if (this.path.contains(sequenceMatcher)) {
                return null;
            }
            ImmutableLinkedList<SequenceMatcher> immutableLinkedList = this.path;
            this.path = this.path.prepend(sequenceMatcher);
            ArrayList<ActionMatcher> arrayList = new ArrayList<ActionMatcher>();
            for (Matcher matcher : sequenceMatcher.getChildren()) {
                List<ActionMatcher> list2 = matcher.accept(this);
                if (list2 == null) {
                    return null;
                }
                arrayList.addAll(list2);
            }
            this.path = immutableLinkedList;
            return arrayList;
        }

        @Override
        public List<ActionMatcher> defaultValue(AbstractMatcher abstractMatcher) {
            return ImmutableList.of();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Handler
    implements MatchHandler {
        private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
        private int fringeIndex;
        private MatcherPath lastMatchPath;

        private Handler() {
        }

        @Override
        public boolean match(MatcherContext<?> matcherContext) {
            Matcher matcher = matcherContext.getMatcher();
            if (matcher.accept(this.isSingleCharMatcherVisitor).booleanValue()) {
                if (this.prepareErrorLocation(matcherContext) && matcher.match(matcherContext)) {
                    if (this.fringeIndex < matcherContext.getCurrentIndex()) {
                        this.fringeIndex = matcherContext.getCurrentIndex();
                        this.lastMatchPath = matcherContext.getPath();
                    }
                    return true;
                }
                return false;
            }
            if (matcher.match(matcherContext)) {
                return true;
            }
            if (matcher instanceof SequenceMatcher) {
                switch (matcherContext.getCurrentChar()) {
                    case '\ufdec': 
                    case '\ufded': 
                    case '\ufdef': {
                        return this.qualifiesForResync(matcherContext) && this.resynchronize(matcherContext);
                    }
                }
                if (System.currentTimeMillis() - RecoveringParseRunner.this.startTimeStamp > RecoveringParseRunner.this.timeout) {
                    throw new TimeoutException(RecoveringParseRunner.this.getRootMatcher(), RecoveringParseRunner.this.buffer, RecoveringParseRunner.this.lastParsingResult);
                }
            }
            return false;
        }

        private boolean qualifiesForResync(MatcherContext matcherContext) {
            if (matcherContext.getCurrentIndex() == matcherContext.getStartIndex() || !matcherContext.getPath().isPrefixOf(this.lastMatchPath)) {
                for (Context context = matcherContext.getParent(); context != null; context = ((MatcherContext)context).getParent()) {
                    if (!(((MatcherContext)context).getMatcher() instanceof SequenceMatcher)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean prepareErrorLocation(MatcherContext matcherContext) {
            switch (matcherContext.getCurrentChar()) {
                case '\ufdea': {
                    return this.willMatchDelError(matcherContext);
                }
                case '\ufdeb': {
                    return this.willMatchInsError(matcherContext);
                }
                case '\ufdec': 
                case '\ufded': 
                case '\ufdef': {
                    return false;
                }
            }
            return true;
        }

        private boolean willMatchDelError(MatcherContext matcherContext) {
            int n = matcherContext.getCurrentIndex();
            matcherContext.advanceIndex(2);
            if (!this.runTestMatch(matcherContext)) {
                matcherContext.setCurrentIndex(n);
                return false;
            }
            matcherContext.setStartIndex(matcherContext.getCurrentIndex());
            if (matcherContext.getParent() != null) {
                ((MatcherContext)matcherContext.getParent()).markError();
            }
            return true;
        }

        private boolean willMatchInsError(MatcherContext matcherContext) {
            int n = matcherContext.getCurrentIndex();
            matcherContext.advanceIndex(1);
            if (!this.runTestMatch(matcherContext)) {
                matcherContext.setCurrentIndex(n);
                return false;
            }
            matcherContext.setStartIndex(matcherContext.getCurrentIndex());
            matcherContext.markError();
            return true;
        }

        private boolean runTestMatch(MatcherContext matcherContext) {
            TestMatcher testMatcher = new TestMatcher(matcherContext.getMatcher());
            MatcherContext matcherContext2 = testMatcher.getSubContext(matcherContext);
            return this.prepareErrorLocation(matcherContext2) && matcherContext2.runMatcher();
        }

        private boolean resynchronize(MatcherContext matcherContext) {
            matcherContext.markError();
            matcherContext.createNode();
            this.rerunAndExecuteErrorActions(matcherContext);
            switch (matcherContext.getCurrentChar()) {
                case '\ufdec': {
                    matcherContext.advanceIndex(1);
                    List<Matcher> list2 = new FollowMatchersVisitor().getFollowMatchers(matcherContext);
                    int n = this.gobbleIllegalCharacters(matcherContext, list2);
                    RecoveringParseRunner.this.currentError.setEndIndex(n);
                    RecoveringParseRunner.this.buffer.replaceInsertedChar(RecoveringParseRunner.this.currentError.getStartIndex() - 1, '\ufded');
                    RecoveringParseRunner.this.buffer.insertChar(n, '\ufdee');
                    matcherContext.advanceIndex(1);
                    break;
                }
                case '\ufded': {
                    matcherContext.advanceIndex(1);
                    while (matcherContext.getCurrentChar() != '\ufdee') {
                        matcherContext.advanceIndex(1);
                        Preconditions.checkState(matcherContext.getCurrentChar() != '\uffff');
                    }
                    matcherContext.advanceIndex(1);
                    break;
                }
                case '\ufdef': {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return true;
        }

        private void rerunAndExecuteErrorActions(MatcherContext matcherContext) {
            int n = matcherContext.getCurrentIndex();
            matcherContext.setCurrentIndex(matcherContext.getStartIndex());
            boolean bl = true;
            for (Matcher matcher : matcherContext.getMatcher().getChildren()) {
                if (bl && !matcher.getSubContext(matcherContext).runMatcher()) {
                    new EmptyMatcher().getSubContext(matcherContext).runMatcher();
                    matcherContext.setIntTag(1);
                    bl = false;
                }
                if (bl) continue;
                matcherContext.setInErrorRecovery(true);
                List<ActionMatcher> list2 = matcher.accept(new CollectResyncActionsVisitor());
                Preconditions.checkState(list2 != null);
                for (ActionMatcher actionMatcher : list2) {
                    actionMatcher.getSubContext(matcherContext).runMatcher();
                }
                matcherContext.setInErrorRecovery(false);
            }
            matcherContext.setCurrentIndex(n);
        }

        private int gobbleIllegalCharacters(MatcherContext matcherContext, List<Matcher> list2) {
            char c;
            block0: while ((c = matcherContext.getCurrentChar()) != '\uffff') {
                for (Matcher matcher : list2) {
                    if (!matcher.accept(new IsStarterCharVisitor(c)).booleanValue()) continue;
                    break block0;
                }
                matcherContext.advanceIndex(1);
            }
            return matcherContext.getCurrentIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeoutException
    extends RuntimeException {
        public final Rule rule;
        public final InputBuffer inputBuffer;
        public final ParsingResult<?> lastParsingResult;

        public TimeoutException(Rule rule, InputBuffer inputBuffer, ParsingResult<?> parsingResult) {
            this.rule = rule;
            this.inputBuffer = inputBuffer;
            this.lastParsingResult = parsingResult;
        }
    }
}

