package name.remal.gradle_plugins

import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.configure
import name.remal.gradle_plugins.utils.doLastOrdered
import org.gradle.api.Project
import org.gradle.api.tasks.compile.AbstractCompile
import org.slf4j.LoggerFactory
import java.io.File
import java.net.URL
import java.net.URLClassLoader

@API
class ClassesProcessingPlugin : ProjectPlugin() {

    companion object {
        @JvmStatic private val logger = LoggerFactory.getLogger(ClassesProcessingPlugin::class.java)
        const val CLASSES_PROCESSING_RUNNER_CLASS = "name.remal.classes_processing.internal.ClassesProcessorRunner"
    }

    override fun apply(project: Project) {
        //if (project.pluginManager.hasPlugin(ClassesProcessingPluginDisabledID))return

        URL("jar:file://valid_jar_url_syntax.jar!/").openConnection().defaultUseCaches = false

        project.tasks.configure(AbstractCompile::class.java) { task ->
            task.doLastOrdered {
                if (task.classpath.isEmpty) return@doLastOrdered
                if (!task.destinationDir.exists()) return@doLastOrdered

                logger.info("Processing classes in ${task.destinationDir}")

                val classpathURLs = task.classpath.filter(File::exists).map { it.toURI().toURL() }.toTypedArray()
                URLClassLoader(classpathURLs, Thread.currentThread().contextClassLoader ?: ClassesProcessingPlugin::class.java.classLoader).use { classLoader ->
                    val runnerClass: Class<*>
                    try {
                        runnerClass = classLoader.loadClass(CLASSES_PROCESSING_RUNNER_CLASS)
                    } catch (e: ClassNotFoundException) {
                        return@use
                    }

                    runnerClass.getMethod("run", File::class.java).invoke(null, task.destinationDir)
                }
            }
        }
    }

}
