package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.DefaultPluginsPluginDisabledID
import name.remal.gradle_plugins.artifact.ArtifactsCacheCleanerPlugin
import name.remal.gradle_plugins.dsl.isBuildSrcProject
import name.remal.gradle_plugins.dsl.isRootProject
import name.remal.gradle_plugins.utils.PluginIds.ECLIPSE_PLUGIN_ID
import name.remal.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.applyPlugin
import name.remal.gradle_plugins.utils.isDisabledBy
import org.gradle.api.Project

@API
class DefaultPluginsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        with(project) {
            if (isDisabledBy(DefaultPluginsPluginDisabledID)) return

            applyPlugin(ArtifactsCacheCleanerPlugin::class.java)

            if (isRootProject) {
                applyPlugin(IDEA_PLUGIN_ID)
                applyPlugin(ECLIPSE_PLUGIN_ID)
                applyPlugin(CheckUpdatesPlugin::class.java)

                if (isBuildSrcProject) {
                    applyPlugin(MergedCoverageMetricsPlugin::class.java)
                }
            }

            applyPlugin(IdeaSettingsPlugin::class.java)
            applyPlugin(EclipseSettingsPlugin::class.java)

            applyPlugin(OSDetectorPlugin::class.java)
            applyPlugin(CommonSettingsPlugin::class.java)
            applyPlugin(DynamicDependenciesPlugin::class.java)
            applyPlugin(DownloadTaskSettingPlugin::class.java)
            applyPlugin(VersionSelectionsPlugin::class.java)

            applyPlugin(JavaSettingsPlugin::class.java)
            applyPlugin(AptPlugin::class.java)
            applyPlugin(FastAnnotationProcessorsPlugin::class.java)
            applyPlugin(KotlinSettingsPlugin::class.java)
            applyPlugin(GroovySettingsPlugin::class.java)

            applyPlugin(JUnitPlatformSettingsPlugin::class.java)

            applyPlugin(FindbugsSettingsPlugin::class.java)
            applyPlugin(QualitySettingsPlugin::class.java)

            applyPlugin(SigningSettingsPlugin::class.java)
            applyPlugin(PublishSettingsPlugin::class.java)
            applyPlugin(BintraySettingsPlugin::class.java)

            applyPlugin(ClassesRelocationPlugin::class.java)
            applyPlugin(MergeJavaResourcesPlugin::class.java)
            applyPlugin(AgentPlugin::class.java)
        }
    }

}
