package name.remal.gradle_plugins

import de.undercouch.gradle.tasks.download.Download
import de.undercouch.gradle.tasks.download.DownloadSpec
import name.remal.gradle_plugins.RemalGradlePlugins.DownloadTaskSettingPluginDisabledID
import name.remal.gradle_plugins.utils.PluginIds.DOWNLOAD_TASK_PLUGIN_ID
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.configureTasks
import name.remal.gradle_plugins.utils.isDisabledBy
import name.remal.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.slf4j.LoggerFactory
import java.time.Duration

@API
class DownloadTaskSettingPlugin : ProjectPlugin() {

    companion object {
        @JvmStatic private val logger = LoggerFactory.getLogger(DownloadTaskSettingPlugin::class.java)
    }

    override fun apply(project: Project) {
        if (project.isDisabledBy(DownloadTaskSettingPluginDisabledID)) return

        project.withPlugin(DOWNLOAD_TASK_PLUGIN_ID) {
            project.configureTasks(Download::class.java, this::setupDownloadSpec)
        }
    }

    private fun setupDownloadSpec(downloadSpec: DownloadSpec) {
        try {
            downloadSpec.onlyIfModified(true)
        } catch (e: NoSuchMethodError) {
            e.writeToLog()
            try {
                downloadSpec.onlyIfNewer(true)
            } catch (e: NoSuchMethodError) {
                e.writeToLog()
            }
        }

        try {
            if (downloadSpec.timeout <= 0) {
                downloadSpec.timeout(Duration.ofMinutes(1).toMillis().toInt())
            }
        } catch (e: NoSuchMethodError) {
            e.writeToLog()
        }
    }

    private fun NoSuchMethodError.writeToLog() {
        logger.info(
            "{}. Check that you use right version of {} plugin.",
            message,
            DOWNLOAD_TASK_PLUGIN_ID
        )
    }

}
