package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.EclipseSettingsPluginDisabledID
import name.remal.gradle_plugins.utils.PluginIds.ECLIPSE_PLUGIN_ID
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.get
import name.remal.gradle_plugins.utils.isDisabledBy
import name.remal.gradle_plugins.utils.withPlugin
import org.gradle.api.Project
import org.gradle.plugins.ide.eclipse.model.EclipseModel

@API
class EclipseSettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(EclipseSettingsPluginDisabledID)) return

        project.withPlugin(ECLIPSE_PLUGIN_ID) {
            setupDependenciesResolution(project)
        }
    }

    private fun setupDependenciesResolution(project: Project) {
        project[EclipseModel::class.java].classpath?.apply {
            isDownloadJavadoc = true
            isDownloadSources = true
        }
    }

}
