package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.FastAnnotationProcessorsPluginDisabledID
import name.remal.gradle_plugins.fast_annotation_processors.FastAnnotationProcessor
import name.remal.gradle_plugins.utils.*
import name.remal.gradle_plugins.utils.PluginIds.JAVA_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.api.tasks.compile.AbstractCompile
import java.util.*

private val fastAnnotationProcessor: List<FastAnnotationProcessor> by lazy { ServiceLoader.load(FastAnnotationProcessor::class.java, RESOURCES_CLASS_LOADER).toList().sorted() }

@API
class FastAnnotationProcessorsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(FastAnnotationProcessorsPluginDisabledID)) return

        if (fastAnnotationProcessor.isEmpty()) return

        project.withPlugin(JAVA_PLUGIN_ID) {
            project.applyPlugin(MergeJavaResourcesPlugin::class.java)
            project.configureTasks(AbstractCompile::class.java) { task ->
                task.doLastOrdered(Int.MAX_VALUE) {
                    val destinationDir = task.destinationDir
                    forEachClassFile(destinationDir) { classFile ->
                        fastAnnotationProcessor.forEach { it.processClassFile(destinationDir, classFile) }
                    }
                }
            }
        }
    }

}
