package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.GitlabToolsPluginDisabledID
import name.remal.gradle_plugins.gitlab_tools.GitlabCreateTagTask
import name.remal.gradle_plugins.gitlab_tools.GitlabToolsExtension
import name.remal.gradle_plugins.utils.ProjectPlugin
import name.remal.gradle_plugins.utils.isDisabledBy
import org.gradle.api.Project

@API
class GitlabToolsPlugin : ProjectPlugin() {

    companion object {
        const val GITLAB_TOOLS_EXTENSION_NAME = "gitlabTools"
        const val GITLAB_CREATE_TAG_TASK_NAME = "gitlabCreateTag"
    }

    override fun apply(project: Project) {
        if (project.isDisabledBy(GitlabToolsPluginDisabledID)) return

        project.extensions.create(GITLAB_TOOLS_EXTENSION_NAME, GitlabToolsExtension::class.java)
        project.tasks.create(GITLAB_CREATE_TAG_TASK_NAME, GitlabCreateTagTask::class.java)
    }

}
