package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.GroovySettingsPluginDisabledID
import name.remal.gradle_plugins.dsl.*
import name.remal.gradle_plugins.utils.*
import name.remal.gradle_plugins.utils.PluginIds.*
import org.gradle.api.Project
import org.gradle.api.tasks.compile.AbstractCompile
import org.gradle.api.tasks.compile.GroovyCompile

@API
class GroovySettingsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(GroovySettingsPluginDisabledID)) return

        project.withPlugins(GROOVY_PLUGIN_ID) {
            project.applyPlugin(JAVA_PLUGIN_ID)
            project.applyPlugin(JavaSettingsPlugin::class.java)

            setupSourceSets(project)
            setupGroovyCompile(project)
        }

        project.withPlugins(GROOVY_PLUGIN_ID, KOTLIN_PLUGIN_IDS) {
            project.afterEvaluateOrdered {
                project.java.sourceSets.configure { sourceSet ->
                    val compileTasks = project.tasks[AbstractCompile::class.java]
                    val compileGroovy = compileTasks.findByName(sourceSet.compileGroovyTaskName) ?: return@configure
                    val compileKotlin = compileTasks.findByName(sourceSet.compileKotlinTaskName) ?: return@configure
                    compileGroovy.classpath = compileGroovy.classpath + project.files(compileKotlin.destinationDir)
                }
            }
        }
    }

    private fun setupSourceSets(project: Project) {
        project.afterEvaluateOrdered(Int.MAX_VALUE) {
            project.java.sourceSets.configure {
                it.resources.makeSrcDirsUnique()
                it.java.makeSrcDirsUnique()
                it.allJava.makeSrcDirsUnique()
                it.allSource.makeSrcDirsUnique()
                it.groovy.groovy.makeSrcDirsUnique()
            }
        }
    }

    private fun setupGroovyCompile(project: Project) {
        project.configureTasks(GroovyCompile::class.java) {
            it.options.apply {
                isDebug = true
                debugOptions.debugLevel = "source,lines,vars"
                isDeprecation = true
                encoding = encoding ?: Constants.ENCODING
            }
        }
    }

}
