package name.remal.gradle_plugins

import name.remal.gradle_plugins.RemalGradlePlugins.IdeaExternalAnnotationsPluginDisabledID
import name.remal.gradle_plugins.dsl.isRootProject
import name.remal.gradle_plugins.utils.*
import name.remal.gradle_plugins.utils.PluginIds.IDEA_PLUGIN_ID
import org.gradle.api.Project
import org.gradle.plugins.ide.idea.model.IdeaModel

@API
class IdeaExternalAnnotationsPlugin : ProjectPlugin() {

    override fun apply(project: Project) {
        if (project.isDisabledBy(IdeaExternalAnnotationsPluginDisabledID)) return

        if (!project.isRootProject) return
        project.applyPlugin(IDEA_PLUGIN_ID)
        project[IdeaModel::class.java].setup { ideaModel ->

            val librariesWithoutAnnotations = compileXPath("//component[@name = 'libraryTable']/library[not(ANNOTATIONS)]")
            ideaModel.processConfigs { document ->
                librariesWithoutAnnotations.evaluateAsNodeList(document)
                    .apply { if (isEmpty) return@processConfigs }
                    .forEach { library ->
                        library.appendElement("ANNOTATIONS")
                            .appendElement("root", mapOf("url" to "file://\$USER_HOME\$/idea-external-annotations"))
                    }
            }

        }
    }

}
